/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.RootAction;
import hudson.model.TopLevelItem;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.ConfigInfoCollector;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.HistoryDescrToConfigInfo;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.plugins.jobConfigHistory.OverviewHistoryDao;
import hudson.plugins.jobConfigHistory.ParsedDateComparator;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.plugins.jobConfigHistory.XmlSyntaxChecker;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.MultipartFormDataParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=-1)
@Extension
public class JobConfigHistoryRootAction
extends JobConfigHistoryBaseAction
implements RootAction {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryRootAction.class.getName());

    @Override
    public final String getUrlName() {
        return "/jobConfigHistory";
    }

    public final String getIconFileName() {
        if (this.hasConfigurePermission() || this.hasJobConfigurePermission() || this.hasReadExtensionPermission()) {
            return "/plugin/jobConfigHistory/img/confighistory.png";
        }
        return null;
    }

    @Exported(visibility=1)
    public final List<ConfigInfo> getConfigs() throws IOException {
        String filter = this.getRequestParameter("filter");
        List<ConfigInfo> configs = null;
        if (filter == null || "system".equals(filter)) {
            configs = this.getSystemConfigs();
        } else if ("all".equals(filter)) {
            configs = this.getJobConfigs("jobs");
            configs.addAll(this.getJobConfigs("deleted"));
            configs.addAll(this.getSystemConfigs());
        } else {
            configs = this.getJobConfigs(filter);
        }
        Collections.sort(configs, ParsedDateComparator.DESCENDING);
        return configs;
    }

    public List<ConfigInfo> getSystemConfigs() throws IOException {
        File[] itemDirs;
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        if (!this.hasConfigurePermission()) {
            return configs;
        }
        for (File itemDir : itemDirs = this.getOverviewHistoryDao().getSystemConfigs()) {
            String itemName = itemDir.getName();
            configs.addAll(HistoryDescrToConfigInfo.convert(itemName, true, this.getOverviewHistoryDao().getSystemHistory(itemName).values(), false));
        }
        return configs;
    }

    public List<ConfigInfo> getJobConfigs(String type) throws IOException {
        if (!this.hasJobConfigurePermission() && !this.hasReadExtensionPermission()) {
            return Collections.emptyList();
        }
        return new ConfigInfoCollector(type, this.getOverviewHistoryDao()).collect();
    }

    public final List<ConfigInfo> getSingleConfigs(String name) throws IOException {
        Collection<HistoryDescr> historyDescriptions = name.contains("_deleted_") ? this.getOverviewHistoryDao().getJobHistory(name).values() : this.getOverviewHistoryDao().getSystemHistory(name).values();
        List<ConfigInfo> configs = HistoryDescrToConfigInfo.convert(name, true, historyDescriptions, false);
        Collections.sort(configs, ParsedDateComparator.DESCENDING);
        return configs;
    }

    public final String getFile() throws IOException {
        String name = this.getRequestParameter("name");
        if (name.contains("_deleted_") && this.hasJobConfigurePermission() || this.hasConfigurePermission()) {
            String timestamp = this.getRequestParameter("timestamp");
            XmlFile xmlFile = this.getOldConfigXml(name, timestamp);
            return xmlFile.asString();
        }
        return "No permission to view config files";
    }

    public final String createLinkToFiles(ConfigInfo config, String type) {
        String link = null;
        String name = config.getJob();
        String timestamp = config.getDate();
        if (name.contains("_deleted_")) {
            try {
                if (this.getSingleConfigs(name).size() > 1) {
                    timestamp = this.getSingleConfigs(name).get(1).getDate();
                    link = "configOutput?type=" + type + "&name=" + name + "&timestamp=" + timestamp;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.FINEST, "Unable to get config for {0}", name);
            }
        } else {
            link = config.getIsJob() ? this.getJenkins().getRootUrl() + "job/" + name + this.getUrlName() + "/configOutput?type=" + type + "&timestamp=" + timestamp : "configOutput?type=" + type + "&name=" + name + "&timestamp=" + timestamp;
        }
        return link;
    }

    @Override
    public AccessControlled getAccessControlledObject() {
        return this.getJenkins();
    }

    @Override
    public void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(Permission.CONFIGURE);
    }

    @Override
    public boolean hasAdminPermission() {
        return this.getAccessControlledObject().hasPermission(Jenkins.ADMINISTER);
    }

    @Override
    public boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Permission.CONFIGURE);
    }

    public boolean hasJobConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Item.CONFIGURE);
    }

    public boolean hasReadExtensionPermission() {
        return this.getAccessControlledObject().hasPermission(Item.EXTENDED_READ);
    }

    @Override
    public final void doDiffFiles(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        rsp.sendRedirect("showDiffFiles?name=" + parser.get("name") + "&timestamp1=" + parser.get("timestamp1") + "&timestamp2=" + parser.get("timestamp2"));
    }

    @Override
    public final List<SideBySideView.Line> getLines(boolean hideVersionDiffs) throws IOException {
        String name = this.getRequestParameter("name");
        if (name.contains("_deleted_") && this.hasJobConfigurePermission() || this.hasConfigurePermission()) {
            String timestamp1 = this.getRequestParameter("timestamp1");
            String timestamp2 = this.getRequestParameter("timestamp2");
            return this.getLines(this.getOldConfigXml(name, timestamp1), this.getOldConfigXml(name, timestamp2), hideVersionDiffs);
        }
        return Collections.emptyList();
    }

    public XmlSyntaxChecker.Answer checkXmlSyntax(String name, String timestamp) {
        return XmlSyntaxChecker.check(this.getOldConfigXml(name, timestamp).getFile());
    }

    public final String getTimestamp(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timeStamp = this.getRequestParameter("timestamp" + timestampNumber);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        try {
            format.setLenient(false);
            format.parse(timeStamp);
            return timeStamp;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public XmlFile getOldConfigXml(String name, String timestamp) {
        if (this.checkParameters(name, timestamp)) {
            if (name.contains("_deleted_")) {
                return this.getHistoryDao().getOldRevision("jobs/" + name, timestamp);
            }
            if (!(this.hasConfigurePermission() || this.hasReadExtensionPermission() || this.hasJobConfigurePermission())) {
                this.checkConfigurePermission();
                return null;
            }
            return this.getHistoryDao().getOldRevision(name, timestamp);
        }
        throw new IllegalArgumentException("Unable to get history from: " + name);
    }

    public boolean checkParameters(String name, String timestamp) {
        this.checkTimestamp(timestamp);
        if (name == null || "null".equals(name)) {
            return false;
        }
        if (name.contains("..")) {
            throw new IllegalArgumentException("Invalid directory name because of '..': " + name);
        }
        return true;
    }

    public final void doRestore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.getAccessControlledObject().checkPermission(Item.CONFIGURE);
        String deletedName = req.getParameter("name");
        String newName = deletedName.split("_deleted_")[0];
        XmlFile configXml = this.getLastAvailableConfigXml(deletedName);
        ByteArrayInputStream is = new ByteArrayInputStream(configXml.asString().getBytes(StandardCharsets.UTF_8));
        String calculatedNewName = this.findNewName(newName);
        TopLevelItem project = this.getJenkins().createProjectFromXML(calculatedNewName, (InputStream)is);
        ((FileHistoryDao)this.getHistoryDao()).copyHistoryAndDelete(deletedName, calculatedNewName);
        rsp.sendRedirect(this.getJenkins().getRootUrl() + project.getUrl());
    }

    public XmlFile getLastAvailableConfigXml(String name) {
        List<ConfigInfo> configInfos;
        XmlFile configXml = null;
        try {
            configInfos = this.getSingleConfigs(name);
        }
        catch (IOException ex) {
            LOG.log(Level.FINEST, "Unable to get config history for {0}", name);
            return configXml;
        }
        if (configInfos.size() > 1) {
            Collections.sort(configInfos, ParsedDateComparator.DESCENDING);
            ConfigInfo lastChange = configInfos.get(1);
            configXml = this.getOldConfigXml(name, lastChange.getDate());
        }
        return configXml;
    }

    public String findNewName(String name) {
        String newName = name;
        int i = 1;
        while (this.getJenkins().getItem(newName) != null) {
            newName = name + "_" + String.valueOf(i);
            ++i;
        }
        return newName;
    }

    public final void doForwardToRestoreQuestion(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String name = req.getParameter("name");
        rsp.sendRedirect("restoreQuestion?name=" + name);
    }

    public final void doDeleteRevision(StaplerRequest req, StaplerResponse rsp) {
        String timestamp = req.getParameter("timestamp");
        String name = req.getParameter("name");
        File[] candidatesArray = name.contains("_deleted_") ? this.getOverviewHistoryDao().getDeletedJobs() : this.getOverviewHistoryDao().getSystemConfigs();
        List candidates = Arrays.stream(candidatesArray).filter(file -> file.getName().equals(name)).collect(Collectors.toList());
        if (candidates.size() == 1) {
            this.getHistoryDao().deleteRevision((File)candidates.get(0), timestamp);
        } else {
            LOG.log(Level.WARNING, "there should be only one entry for \"{0}\". Instead there are {1}", new Object[]{name, candidates.size()});
        }
    }

    @Override
    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    protected OverviewHistoryDao getOverviewHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    public Api getApi() {
        return new Api((Object)this);
    }
}

