/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryFileFilter;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.OverviewHistoryDao;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.Purgeable;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

@Extension
public class JobConfigHistoryPurger
extends PeriodicWork {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryPurger.class.getName());
    private final JobConfigHistory plugin;
    private int maxAge;
    private Purgeable purgeable;
    private final OverviewHistoryDao overviewHistoryDao;

    public JobConfigHistoryPurger() {
        this((JobConfigHistory)Jenkins.getInstance().getPlugin(JobConfigHistory.class));
    }

    private JobConfigHistoryPurger(JobConfigHistory plugin) {
        this(plugin, PluginUtils.getHistoryDao(plugin, null) instanceof Purgeable ? (Purgeable)((Object)PluginUtils.getHistoryDao(plugin, null)) : null, PluginUtils.getHistoryDao(plugin, null));
    }

    JobConfigHistoryPurger(JobConfigHistory plugin, Purgeable purgeable, OverviewHistoryDao overviewHistoryDao) {
        this.plugin = plugin;
        this.purgeable = purgeable;
        this.overviewHistoryDao = overviewHistoryDao;
    }

    public long getRecurrencePeriod() {
        return 86400000L;
    }

    protected void doRun() throws Exception {
        String maxAgeString = this.plugin.getMaxDaysToKeepEntries();
        int maxAge = 0;
        if (StringUtils.isNotEmpty((String)maxAgeString)) {
            try {
                maxAge = Integer.parseInt(maxAgeString);
                if (maxAge > 0) {
                    LOG.log(Level.FINE, "checking for history files to purge (max age of {0} days allowed)", maxAge);
                    this.setMaxAge(maxAge);
                    this.purgeHistoryByAge();
                }
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "maximum age of history entries not formatted properly, unable to purge: {0}", maxAgeString);
            }
        }
    }

    void purgeHistoryByAge() {
        this.purgeSystemOrJobHistory(this.overviewHistoryDao.getSystemConfigs());
        this.purgeSystemOrJobHistory(this.overviewHistoryDao.getJobs(""));
    }

    void purgeSystemOrJobHistory(File[] itemDirs) {
        if (itemDirs != null && itemDirs.length > 0) {
            for (File itemDir : itemDirs) {
                Object[] historyDirs = itemDir.listFiles(HistoryFileFilter.INSTANCE);
                if (historyDirs == null) continue;
                Arrays.sort(historyDirs);
                for (Object historyDir : historyDirs) {
                    if (!this.isTooOld((File)historyDir)) break;
                    if (this.purgeable.isCreatedEntry((File)historyDir)) continue;
                    LOG.log(Level.FINEST, "Should delete: {0}", historyDir);
                    this.deleteDirectory((File)historyDir);
                }
            }
        }
    }

    boolean isTooOld(File historyDir) {
        Date parsedDate = null;
        SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        try {
            parsedDate = dateParser.parse(historyDir.getName());
        }
        catch (ParseException ex) {
            LOG.log(Level.WARNING, "Unable to parse Date: {0}", ex);
        }
        GregorianCalendar historyDate = new GregorianCalendar();
        if (parsedDate != null) {
            historyDate.setTime(parsedDate);
            GregorianCalendar oldestAllowedDate = new GregorianCalendar();
            ((Calendar)oldestAllowedDate).add(6, -this.getMaxAge());
            if (historyDate.before(oldestAllowedDate)) {
                return true;
            }
        }
        return false;
    }

    void deleteDirectory(File dir) {
        for (File file : dir.listFiles()) {
            if (file.delete()) continue;
            LOG.log(Level.WARNING, "problem deleting history file: {0}", file);
        }
        if (!dir.delete()) {
            LOG.log(Level.WARNING, "problem deleting history directory: {0}", dir);
        }
    }

    int getMaxAge() {
        return this.maxAge;
    }

    void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }
}

