/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.XmlFile;
import hudson.maven.MavenModule;
import hudson.model.AbstractItem;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.plugins.jobConfigHistory.ParsedDateComparator;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.security.AccessControlled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=-1)
public class JobConfigHistoryProjectAction
extends JobConfigHistoryBaseAction {
    private final transient AbstractItem project;

    public JobConfigHistoryProjectAction(AbstractItem project) {
        this.project = project;
    }

    public JobConfigHistoryProjectAction(Jenkins jenkins, AbstractItem project) {
        super(jenkins);
        this.project = project;
    }

    public final String getIconFileName() {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            return null;
        }
        if (this.project instanceof TopLevelItem) {
            return "/plugin/jobConfigHistory/img/confighistory.png";
        }
        if (this.getPlugin().getSaveModuleConfiguration() && this.project instanceof MavenModule) {
            return "/plugin/jobConfigHistory/img/confighistory.png";
        }
        return null;
    }

    public final List<ConfigInfo> getJobConfigs() throws IOException {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        ArrayList<HistoryDescr> values = new ArrayList<HistoryDescr>(this.getHistoryDao().getRevisions(this.project.getConfigFile()).values());
        String maxEntriesPerPageAsString = this.getPlugin().getMaxEntriesPerPage();
        int maxEntriesPerPage = maxEntriesPerPageAsString != null && !maxEntriesPerPageAsString.isEmpty() ? Math.min(values.size(), Integer.parseInt(maxEntriesPerPageAsString)) : values.size();
        for (HistoryDescr historyDescr : values.subList(0, maxEntriesPerPage)) {
            String timestamp = historyDescr.getTimestamp();
            XmlFile oldRevision = this.getHistoryDao().getOldRevision(this.project, timestamp);
            if (oldRevision.getFile() != null) {
                configs.add(ConfigInfo.create(this.project.getFullName(), true, historyDescr, true));
                continue;
            }
            if (!"Deleted".equals(historyDescr.getOperation())) continue;
            configs.add(ConfigInfo.create(this.project.getFullName(), false, historyDescr, true));
        }
        Collections.sort(configs, ParsedDateComparator.DESCENDING);
        return configs;
    }

    @Exported(name="jobConfigHistory", visibility=1)
    public final List<ConfigInfo> getJobConfigsREST() throws IOException {
        List<ConfigInfo> configs = null;
        try {
            configs = this.getJobConfigs();
        }
        catch (AccessDeniedException e) {
            configs = new ArrayList<ConfigInfo>();
        }
        return configs;
    }

    public final String getFile() throws IOException {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp = this.getRequestParameter("timestamp");
        XmlFile xmlFile = this.getOldConfigXml(timestamp);
        return xmlFile.asString();
    }

    public final AbstractItem getProject() {
        return this.project;
    }

    @Override
    public AccessControlled getAccessControlledObject() {
        return this.project;
    }

    @Override
    public void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(Item.CONFIGURE);
    }

    @Override
    public boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Item.CONFIGURE);
    }

    public boolean hasReadExtensionPermission() {
        return this.getAccessControlledObject().hasPermission(Item.EXTENDED_READ);
    }

    public final String getTimestamp(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timeStamp = this.getRequestParameter("timestamp" + timestampNumber);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        try {
            format.setLenient(false);
            format.parse(timeStamp);
            return timeStamp;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public final String getUser(int timestampNumber) {
        this.checkConfigurePermission();
        return ((HistoryDescr)this.getHistoryDao().getRevisions(this.project.getConfigFile()).get(this.getTimestamp(timestampNumber))).getUser();
    }

    public final String getOperation(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        return ((HistoryDescr)this.getHistoryDao().getRevisions(this.project.getConfigFile()).get(this.getTimestamp(timestampNumber))).getOperation();
    }

    public final String getNextTimestamp(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp = this.getRequestParameter("timestamp" + timestampNumber);
        SortedMap<String, HistoryDescr> revisions = this.getHistoryDao().getRevisions(this.project.getConfigFile());
        Iterator<Map.Entry<String, HistoryDescr>> itr = revisions.entrySet().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getValue().getTimestamp().equals(timestamp) || !itr.hasNext()) continue;
            return itr.next().getValue().getTimestamp();
        }
        return timestamp;
    }

    public final String getPrevTimestamp(int timestampNumber) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp = this.getRequestParameter("timestamp" + timestampNumber);
        SortedMap<String, HistoryDescr> revisions = this.getHistoryDao().getRevisions(this.project.getConfigFile());
        Iterator<Map.Entry<String, HistoryDescr>> itr = revisions.entrySet().iterator();
        String prevTimestamp = timestamp;
        while (itr.hasNext()) {
            String checkTimestamp = itr.next().getValue().getTimestamp();
            if (checkTimestamp.equals(timestamp)) {
                return prevTimestamp;
            }
            prevTimestamp = checkTimestamp;
        }
        return timestamp;
    }

    public final List<SideBySideView.Line> getLines() throws IOException {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        String timestamp1 = this.getRequestParameter("timestamp1");
        String timestamp2 = this.getRequestParameter("timestamp2");
        XmlFile configXml1 = this.getOldConfigXml(timestamp1);
        String[] configXml1Lines = configXml1.asString().split("\\n");
        XmlFile configXml2 = this.getOldConfigXml(timestamp2);
        String[] configXml2Lines = configXml2.asString().split("\\n");
        String diffAsString = this.getDiffAsString(configXml1.getFile(), configXml2.getFile(), configXml1Lines, configXml2Lines);
        List<String> diffLines = Arrays.asList(diffAsString.split("\n"));
        return this.getDiffLines(diffLines);
    }

    private XmlFile getOldConfigXml(String timestamp) {
        if (!this.hasConfigurePermission() && !this.hasReadExtensionPermission()) {
            this.checkConfigurePermission();
            return null;
        }
        XmlFile oldRevision = this.getHistoryDao().getOldRevision(this.project, timestamp);
        if (oldRevision.getFile() != null) {
            return oldRevision;
        }
        throw new IllegalArgumentException("Non existent timestamp " + timestamp);
    }

    public final void doRestore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.checkConfigurePermission();
        String timestamp = req.getParameter("timestamp");
        XmlFile xmlFile = this.getHistoryDao().getOldRevision(this.project, timestamp);
        ByteArrayInputStream is = new ByteArrayInputStream(xmlFile.asString().getBytes("UTF-8"));
        this.project.updateByXml((Source)new StreamSource(is));
        this.project.save();
        rsp.sendRedirect(this.getJenkins().getRootUrl() + this.project.getUrl());
    }

    public final void doForwardToRestoreQuestion(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp = req.getParameter("timestamp");
        rsp.sendRedirect("restoreQuestion?timestamp=" + timestamp);
    }

    @Override
    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    public Api getApi() {
        return new Api((Object)this);
    }
}

