/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import difflib.DiffUtils;
import difflib.Patch;
import difflib.StringUtills;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.plugins.jobConfigHistory.GetDiffLines;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.security.AccessControlled;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class JobConfigHistoryBaseAction
implements Action {
    private final Hudson hudson;

    public JobConfigHistoryBaseAction() {
        this.hudson = Hudson.getInstance();
    }

    JobConfigHistoryBaseAction(Hudson hudson) {
        this.hudson = hudson;
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return "jobConfigHistory";
    }

    public final String getOutputType() {
        if ("xml".equalsIgnoreCase(this.getRequestParameter("type"))) {
            return "xml";
        }
        return "plain";
    }

    protected boolean checkTimestamp(String timestamp) {
        if (timestamp == null || "null".equals(timestamp)) {
            return false;
        }
        PluginUtils.parsedDate(timestamp);
        return true;
    }

    protected String getRequestParameter(String parameterName) {
        return this.getCurrentRequest().getParameter(parameterName);
    }

    protected abstract void checkConfigurePermission();

    protected abstract boolean hasConfigurePermission();

    protected Hudson getHudson() {
        return this.hudson;
    }

    protected abstract AccessControlled getAccessControlledObject();

    public final List<SideBySideView.Line> getDiffLines(List<String> diffLines) throws IOException {
        return new GetDiffLines(diffLines).get();
    }

    protected final String getDiffAsString(File file1, File file2, String[] file1Lines, String[] file2Lines) {
        Patch patch = DiffUtils.diff(Arrays.asList(file1Lines), Arrays.asList(file2Lines));
        List unifiedDiff = DiffUtils.generateUnifiedDiff((String)file1.getPath(), (String)file2.getPath(), Arrays.asList(file1Lines), (Patch)patch, (int)3);
        return StringUtills.join((Iterable)unifiedDiff, (String)"\n") + "\n";
    }

    public void doDiffFiles(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        String timestamp1 = req.getParameter("timestamp1");
        String timestamp2 = req.getParameter("timestamp2");
        if (PluginUtils.parsedDate(timestamp1).after(PluginUtils.parsedDate(timestamp2))) {
            timestamp1 = req.getParameter("timestamp2");
            timestamp2 = req.getParameter("timestamp1");
        }
        rsp.sendRedirect("showDiffFiles?timestamp1=" + timestamp1 + "&timestamp2=" + timestamp2);
    }

    public final void doDiffFilesPrevNext(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp1 = req.getParameter("timestamp1");
        String timestamp2 = req.getParameter("timestamp2");
        rsp.sendRedirect("showDiffFiles?timestamp1=" + timestamp1 + "&timestamp2=" + timestamp2);
    }

    protected StaplerRequest getCurrentRequest() {
        return Stapler.getCurrentRequest();
    }

    protected JobConfigHistory getPlugin() {
        return PluginUtils.getPlugin();
    }

    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }
}

