/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import bmsi.util.Diff;
import bmsi.util.DiffPrint;
import difflib.Chunk;
import difflib.Delta;
import difflib.DiffRow;
import difflib.DiffRowGenerator;
import difflib.DiffUtils;
import difflib.Patch;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.security.AccessControlled;
import hudson.util.MultipartFormDataParser;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JobConfigHistoryBaseAction
implements Action {
    private final Hudson hudson = Hudson.getInstance();

    public final String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return "jobConfigHistory";
    }

    public final boolean wantRawOutput() {
        return this.isTypeParameter("raw");
    }

    public final boolean wantXmlOutput() {
        return this.isTypeParameter("xml");
    }

    public final String getFile() throws IOException {
        this.checkConfigurePermission();
        XmlFile xmlFile = this.getConfigXml(this.getRequestParameter("file"));
        return xmlFile.asString();
    }

    private boolean isTypeParameter(String toCompare) {
        return this.getRequestParameter("type").equalsIgnoreCase(toCompare);
    }

    protected XmlFile getConfigXml(String diffDir) {
        JobConfigHistory plugin = (JobConfigHistory)this.hudson.getPlugin(JobConfigHistory.class);
        String allowedHistoryRootDir = plugin.getHistoryRootDir() == null || plugin.getHistoryRootDir().isEmpty() ? plugin.getConfiguredHistoryRootDir().getAbsolutePath() : plugin.getConfiguredHistoryRootDir().getParent();
        File configFile = null;
        if (diffDir != null) {
            if (!diffDir.startsWith(allowedHistoryRootDir) || diffDir.contains("..")) {
                throw new IllegalArgumentException(diffDir + " does not start with " + allowedHistoryRootDir + " or contains '..'");
            }
            configFile = plugin.getConfigFile(new File(diffDir));
        }
        if (configFile == null) {
            throw new IllegalArgumentException("Unable to get history from: " + diffDir);
        }
        return new XmlFile(configFile);
    }

    protected String getRequestParameter(String parameterName) {
        return Stapler.getCurrentRequest().getParameter(parameterName);
    }

    protected abstract void checkConfigurePermission();

    protected abstract boolean hasConfigurePermission();

    protected final Hudson getHudson() {
        return this.hudson;
    }

    protected final JobConfigHistory getPlugin() {
        return (JobConfigHistory)this.hudson.getPlugin(JobConfigHistory.class);
    }

    protected abstract AccessControlled getAccessControlledObject();

    public final void doDiffFiles(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        rsp.sendRedirect("showDiffFiles?histDir1=" + parser.get("histDir1") + "&histDir2=" + parser.get("histDir2"));
    }

    public final String getDiffFile() throws IOException {
        this.checkConfigurePermission();
        XmlFile configXml1 = this.getConfigXml(this.getRequestParameter("histDir1"));
        String[] configXml1Lines = configXml1.asString().split("\\n");
        XmlFile configXml2 = this.getConfigXml(this.getRequestParameter("histDir2"));
        String[] configXml2Lines = configXml2.asString().split("\\n");
        return this.getDiff(configXml1.getFile(), configXml2.getFile(), configXml1Lines, configXml2Lines);
    }

    public final List<SideBySideView.Line> getDiffLines() throws IOException {
        List<String> diffLines = Arrays.asList(this.getDiffFile().split("\n"));
        Patch diff = DiffUtils.parseUnifiedDiff(diffLines);
        SideBySideView view = new SideBySideView();
        DiffRowGenerator.Builder builder = new DiffRowGenerator.Builder();
        builder.columnWidth(Integer.MAX_VALUE);
        DiffRowGenerator dfg = builder.build();
        int previousLeftPos = 0;
        for (Delta delta : diff.getDeltas()) {
            Chunk original = delta.getOriginal();
            Chunk revised = delta.getRevised();
            List diffRows = dfg.generateDiffRows(original.getLines(), revised.getLines());
            int leftPos = original.getPosition() + 1;
            int rightPos = revised.getPosition() + 1;
            if (previousLeftPos > 0 && leftPos - previousLeftPos > 1) {
                SideBySideView.Line skippingLine = new SideBySideView.Line();
                skippingLine.skipping = true;
                view.addLine(skippingLine);
            }
            for (DiffRow row : diffRows) {
                DiffRow.Tag tag = row.getTag();
                SideBySideView.Line line = new SideBySideView.Line();
                if (tag == DiffRow.Tag.INSERT) {
                    line.left.cssClass = "diff_original";
                    line.right.lineNumber = rightPos;
                    line.right.text = row.getNewLine();
                    line.right.cssClass = "diff_revised";
                    ++rightPos;
                } else if (tag == DiffRow.Tag.CHANGE) {
                    if (StringUtils.isNotEmpty((String)row.getOldLine())) {
                        line.left.lineNumber = leftPos;
                        line.left.text = row.getOldLine();
                        ++leftPos;
                    }
                    line.left.cssClass = "diff_original";
                    if (StringUtils.isNotEmpty((String)row.getNewLine())) {
                        line.right.lineNumber = rightPos;
                        line.right.text = row.getNewLine();
                        ++rightPos;
                    }
                    line.right.cssClass = "diff_revised";
                } else if (tag == DiffRow.Tag.DELETE) {
                    line.left.lineNumber = leftPos;
                    line.left.text = row.getOldLine();
                    line.left.cssClass = "diff_original";
                    line.right.cssClass = "diff_revised";
                } else if (tag == DiffRow.Tag.EQUAL) {
                    line.left.lineNumber = leftPos;
                    line.left.text = row.getOldLine();
                    ++leftPos;
                    line.right.lineNumber = rightPos;
                    line.right.text = row.getNewLine();
                    ++rightPos;
                } else {
                    throw new IllegalStateException("Unknown tag pattern: " + tag);
                }
                view.addLine(line);
                previousLeftPos = ++leftPos;
            }
        }
        view.clearDuplicateLines();
        return view.getLines();
    }

    protected final String getDiff(File file1, File file2, String[] file1Lines, String[] file2Lines) {
        Diff.change change2 = new Diff(file1Lines, file2Lines).diff_2(false);
        DiffPrint.UnifiedPrint unifiedPrint = new DiffPrint.UnifiedPrint(file1Lines, file2Lines);
        StringWriter output = new StringWriter();
        unifiedPrint.setOutput(output);
        unifiedPrint.print_header(file1.getPath(), file2.getPath());
        unifiedPrint.print_script(change2);
        return output.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SideBySideView {
        private final List<Line> lines = new ArrayList<Line>();

        public List<Line> getLines() {
            return Collections.unmodifiableList(this.lines);
        }

        public void addLine(Line line) {
            this.lines.add(line);
        }

        public void clearDuplicateLines() {
            Iterator<Line> iter = this.lines.iterator();
            HashSet<String> duplicateLineChecker = new HashSet<String>();
            while (iter.hasNext()) {
                Line line = iter.next();
                String lineNum = line.left.getLineNumber();
                if (lineNum.length() == 0) continue;
                if (duplicateLineChecker.contains(lineNum)) {
                    iter.remove();
                    continue;
                }
                duplicateLineChecker.add(lineNum);
            }
        }

        public static class Line {
            private final Item left = new Item();
            private final Item right = new Item();
            private boolean skipping = false;

            public Item getLeft() {
                return this.left;
            }

            public Item getRight() {
                return this.right;
            }

            public boolean isSkipping() {
                return this.skipping;
            }

            public static class Item {
                private Integer lineNumber;
                private String text;
                private String cssClass;

                public String getLineNumber() {
                    return this.lineNumber == null ? "" : String.valueOf(this.lineNumber);
                }

                public String getText() {
                    return this.text;
                }

                public String getCssClass() {
                    return this.cssClass;
                }
            }
        }
    }
}

