/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Plugin;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Saveable;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JobConfigHistory
extends Plugin {
    private String historyRootDir;
    private String maxHistoryEntries;
    private boolean saveSystemConfiguration;
    private boolean saveItemGroupConfiguration;
    private boolean skipDuplicateHistory;
    private String excludePattern;
    private transient Pattern excludeRegexpPattern;
    private static final Logger LOG = Logger.getLogger(JobConfigHistory.class.getName());
    public static final FileFilter HISTORY_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return JobConfigHistory.isHistoryDir(file);
        }
    };
    public static final FileFilter DELETED_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().contains("_deleted_");
        }
    };

    public void start() throws Exception {
        this.load();
        this.loadRegexpPatterns();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.historyRootDir = formData.getString("historyRootDir").trim();
        this.maxHistoryEntries = formData.getString("maxHistoryEntries").trim();
        this.saveSystemConfiguration = formData.getBoolean("saveSystemConfiguration");
        this.saveItemGroupConfiguration = formData.getBoolean("saveItemGroupConfiguration");
        this.skipDuplicateHistory = formData.getBoolean("skipDuplicateHistory");
        this.excludePattern = formData.getString("excludePattern");
        this.save();
        this.loadRegexpPatterns();
    }

    public String getHistoryRootDir() {
        return this.historyRootDir;
    }

    public String getDefaultRootDir() {
        return "config-history";
    }

    public String getMaxHistoryEntries() {
        return this.maxHistoryEntries;
    }

    protected void setMaxHistoryEntries(String maxHistoryEntries) {
        this.maxHistoryEntries = maxHistoryEntries;
    }

    public boolean getSaveSystemConfiguration() {
        return this.saveSystemConfiguration;
    }

    public void setSaveSystemConfiguration(boolean bool) {
        this.saveSystemConfiguration = bool;
    }

    public boolean getSaveItemGroupConfiguration() {
        return this.saveItemGroupConfiguration;
    }

    public boolean getSkipDuplicateHistory() {
        return this.skipDuplicateHistory;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getDefaultExcludePattern() {
        return "queue|nodeMonitors|UpdateCenter|global-build-stats";
    }

    protected Pattern getExcludeRegexpPattern() {
        return this.excludeRegexpPattern;
    }

    private void loadRegexpPatterns() {
        this.excludeRegexpPattern = this.loadRegex(this.excludePattern);
    }

    private Pattern loadRegex(String patternString) {
        if (patternString != null) {
            try {
                return Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }
        return null;
    }

    protected File getJobHistoryRootDir() {
        File rootDir = this.historyRootDir == null || this.historyRootDir.isEmpty() ? new File(this.getConfiguredHistoryRootDir() + "/" + "jobs") : new File(this.getConfiguredHistoryRootDir().getParent() + "/" + "jobs");
        return rootDir;
    }

    protected File getConfiguredHistoryRootDir() {
        File rootDir = this.historyRootDir == null || this.historyRootDir.isEmpty() ? new File(Hudson.getInstance().root.getPath() + "/" + "config-history") : (this.historyRootDir.matches("^(/|\\\\|[a-zA-Z]:).*") ? new File(this.historyRootDir + "/" + "config-history") : new File(Hudson.getInstance().root.getPath() + "/" + this.historyRootDir + "/" + "config-history"));
        return rootDir;
    }

    protected File getHistoryDir(XmlFile xmlFile) {
        File historyDir;
        String hudsonRootDir;
        String configRootDir = xmlFile.getFile().getParent();
        if (!configRootDir.startsWith(hudsonRootDir = Hudson.getInstance().root.getPath())) {
            LOG.warning("Trying to get history dir for object outside of HUDSON: " + xmlFile);
            return null;
        }
        String underRootDir = null;
        if (configRootDir.equals(hudsonRootDir)) {
            String xmlFileName = xmlFile.getFile().getName();
            underRootDir = xmlFileName.substring(0, xmlFileName.lastIndexOf(46));
        }
        if (underRootDir == null) {
            String remainingPath = configRootDir.substring(hudsonRootDir.length() + "jobs".length() + 1);
            historyDir = new File(this.getJobHistoryRootDir(), remainingPath);
        } else {
            historyDir = new File(this.getConfiguredHistoryRootDir(), underRootDir);
        }
        return historyDir;
    }

    protected File getConfigFile(File historyDir) {
        File configFile = null;
        if (historyDir.exists() && JobConfigHistory.isHistoryDir(historyDir)) {
            File[] listing;
            for (File file : listing = historyDir.listFiles()) {
                if (file.getName().equals("history.xml") || !file.getName().matches(".*\\.xml$")) continue;
                configFile = file;
                break;
            }
        }
        return configFile;
    }

    protected boolean isSaveable(Saveable item, XmlFile xmlFile) {
        boolean saveable = false;
        if (item instanceof AbstractProject) {
            saveable = true;
        } else if (this.saveSystemConfiguration && xmlFile.getFile().getParentFile().equals(Hudson.getInstance().root)) {
            Matcher matcher;
            saveable = this.excludeRegexpPattern != null ? !(matcher = this.excludeRegexpPattern.matcher(xmlFile.getFile().getName())).find() : true;
        } else if (this.saveItemGroupConfiguration && item instanceof ItemGroup) {
            saveable = true;
        }
        if (saveable && this.skipDuplicateHistory && this.hasDuplicateHistory(xmlFile)) {
            LOG.fine("found duplicate history, skipping save of " + xmlFile);
            saveable = false;
        }
        return saveable;
    }

    private boolean hasDuplicateHistory(XmlFile xmlFile) {
        boolean isDuplicated = false;
        File[] historyDirs = this.getHistoryDir(xmlFile).listFiles(HISTORY_FILTER);
        if (historyDirs != null && historyDirs.length != 0) {
            Arrays.sort(historyDirs, Collections.reverseOrder());
            File lastFile = new File(historyDirs[0], xmlFile.getFile().getName());
            if (lastFile.exists()) {
                XmlFile lastXmlFile = new XmlFile(lastFile);
                try {
                    if (xmlFile.asString().equals(lastXmlFile.asString())) {
                        isDuplicated = true;
                    }
                }
                catch (IOException e) {
                    LOG.warning("unable to check for duplicate previous history file: " + lastXmlFile + "\n" + e);
                }
            }
        }
        return isDuplicated;
    }

    protected void checkForPurgeByQuantity(File itemHistoryRoot) {
        int maxEntries = 0;
        if (StringUtils.isNotEmpty((String)this.maxHistoryEntries)) {
            try {
                maxEntries = new Integer(this.getMaxHistoryEntries());
                maxEntries = Integer.parseInt(this.getMaxHistoryEntries());
                if (maxEntries < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                LOG.warning("maximum number of history entries not formatted properly, unable to purge: " + this.maxHistoryEntries);
            }
        }
        if (maxEntries > 0) {
            LOG.fine("checking for history files to purge (" + this.maxHistoryEntries + " max allowed)");
            this.purgeHistoryByQuantity(itemHistoryRoot, maxEntries);
        }
    }

    private void purgeHistoryByQuantity(File historyRoot, int maxEntries) {
        int entriesToLeave = maxEntries - 1;
        File[] historyDirs = historyRoot.listFiles(HISTORY_FILTER);
        if (historyDirs != null && historyDirs.length >= entriesToLeave) {
            Arrays.sort(historyDirs, Collections.reverseOrder());
            for (int i = entriesToLeave; i < historyDirs.length; ++i) {
                LOG.fine("purging old directory from history logs: " + historyDirs[i]);
                for (File file : historyDirs[i].listFiles()) {
                    if (file.delete()) continue;
                    LOG.warning("problem deleting history file: " + file);
                }
                if (historyDirs[i].delete()) continue;
                LOG.warning("problem deleting history directory: " + historyDirs[i]);
            }
        }
    }

    private static boolean isHistoryDir(File dir) {
        return new File(dir, "history.xml").exists();
    }

    public FormValidation doCheckMaxHistoryEntries(@QueryParameter String value) {
        try {
            if (StringUtils.isNotBlank((String)value) && Integer.parseInt(value) < 0) {
                throw new NumberFormatException();
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException ex) {
            return FormValidation.error((String)"Enter a valid positive integer");
        }
    }

    public FormValidation doCheckExcludePattern(@QueryParameter String value) {
        try {
            Pattern.compile(value);
            return FormValidation.ok();
        }
        catch (PatternSyntaxException e) {
            return FormValidation.error((String)("Invalid regexp:\n" + e));
        }
    }
}

