/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.provider.data;

import com.redhat.jenkins.plugins.ci.GlobalCIConfiguration;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class ProviderData
implements Describable<ProviderData>,
Serializable {
    private static final long serialVersionUID = -5475213587386619340L;
    protected String name;
    protected transient JMSMessagingProvider provider;

    public ProviderData() {
    }

    public ProviderData(String name) {
        this.name = name;
        this.setProvider();
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
        this.setProvider();
    }

    public abstract boolean hasOverrides();

    public abstract String getSubscriberTopic();

    public abstract String getPublisherTopic();

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ProviderData thatp = (ProviderData)that;
        return this.name != null ? this.name.equals(thatp.name) : thatp.name == null;
    }

    private void setProvider() {
        this.provider = GlobalCIConfiguration.get().getProvider(this.name);
    }

    public static abstract class ProviderDataDescriptor
    extends Descriptor<ProviderData> {
        public static ExtensionList<ProviderDataDescriptor> all() {
            return Jenkins.getInstance().getExtensionList(ProviderDataDescriptor.class);
        }
    }
}

