/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.provider.data;

import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.messaging.checks.MsgCheck;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FedMsgSubscriberProviderData
extends FedMsgProviderData {
    private static final long serialVersionUID = -2179136605130421113L;
    public static final String DEFAULT_VARIABLE_NAME = "CI_MESSAGE";
    public static final Integer DEFAULT_TIMEOUT_IN_MINUTES = 60;
    private MessagingProviderOverrides overrides;
    private List<MsgCheck> checks = new ArrayList<MsgCheck>();
    private String variable;
    private Integer timeout = DEFAULT_TIMEOUT_IN_MINUTES;

    @DataBoundConstructor
    public FedMsgSubscriberProviderData() {
    }

    public FedMsgSubscriberProviderData(String name) {
        this(name, null);
    }

    public FedMsgSubscriberProviderData(String name, MessagingProviderOverrides overrides) {
        super(name, overrides);
    }

    public FedMsgSubscriberProviderData(String name, MessagingProviderOverrides overrides, List<MsgCheck> checks, String variable, Integer timeout) {
        this(name, overrides);
        this.checks = checks;
        this.variable = variable;
        this.timeout = timeout;
    }

    public List<MsgCheck> getChecks() {
        return this.checks;
    }

    @DataBoundSetter
    public void setChecks(List<MsgCheck> checks) {
        this.checks = checks;
    }

    public String getVariable() {
        return this.variable;
    }

    @DataBoundSetter
    public void setVariable(String variable) {
        this.variable = variable;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Descriptor<ProviderData> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(FedMsgSubscriberProviderDataDescriptor.class);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        FedMsgSubscriberProviderData thatp = (FedMsgSubscriberProviderData)that;
        return (this.name != null ? this.name.equals(thatp.name) : thatp.name == null) && (this.overrides != null ? this.overrides.equals(thatp.overrides) : thatp.overrides == null) && (this.checks != null ? this.checks.equals(thatp.checks) : thatp.checks == null) && (this.variable != null ? this.variable.equals(thatp.variable) : thatp.variable == null) && (this.timeout != null ? this.timeout.equals(thatp.timeout) : thatp.timeout == null);
    }

    @Extension
    public static class FedMsgSubscriberProviderDataDescriptor
    extends ProviderData.ProviderDataDescriptor {
        public String getDisplayName() {
            return "FedMsg Subscriber Provider Data";
        }

        public FedMsgSubscriberProviderData newInstance(StaplerRequest sr, JSONObject jo) {
            MessagingProviderOverrides mpo = null;
            if (!jo.getJSONObject("overrides").isNullObject()) {
                mpo = new MessagingProviderOverrides(jo.getJSONObject("overrides").getString("topic"));
            }
            List checks = sr.bindJSONToList(MsgCheck.class, jo.get("checks"));
            String variable = null;
            if (jo.has("variable")) {
                variable = jo.getString("variable");
            }
            Integer timeout = null;
            if (jo.has("timeout") && !StringUtils.isEmpty((CharSequence)jo.getString("timeout"))) {
                timeout = jo.getInt("timeout");
            }
            return new FedMsgSubscriberProviderData(jo.getString("name"), mpo, checks, variable, timeout);
        }

        public String getDefaultVariable() {
            return FedMsgSubscriberProviderData.DEFAULT_VARIABLE_NAME;
        }

        public Integer getDefaultTimeout() {
            return DEFAULT_TIMEOUT_IN_MINUTES;
        }

        public FormValidation doCheckVariable(@QueryParameter String variable) {
            if (variable == null || variable.isEmpty()) {
                return FormValidation.error((String)"Please enter a variable name to hold the received message result.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String timeout) {
            try {
                if (timeout == null || timeout.isEmpty() || Integer.parseInt(timeout) <= 0) {
                    return FormValidation.error((String)"Please enter a positive timeout value.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please enter a valid timeout value.");
            }
            return FormValidation.ok();
        }

        public String getConfigPage() {
            return "fedmsg-subscriber.jelly";
        }
    }
}

