/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.provider.data;

import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.Extension;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class FedMsgPublisherProviderData
extends FedMsgProviderData {
    private static final long serialVersionUID = -2179136605130421113L;
    private String messageContent;
    private Boolean failOnError = false;

    @DataBoundConstructor
    public FedMsgPublisherProviderData() {
    }

    public FedMsgPublisherProviderData(String name) {
        this(name, null);
    }

    public FedMsgPublisherProviderData(String name, MessagingProviderOverrides overrides) {
        super(name, overrides);
    }

    public FedMsgPublisherProviderData(String name, MessagingProviderOverrides overrides, String messageContent, Boolean failOnError) {
        this(name, overrides);
        this.messageContent = messageContent;
        this.failOnError = failOnError;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    @DataBoundSetter
    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public Boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public Descriptor<ProviderData> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(FedMsgPublisherProviderDataDescriptor.class);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        FedMsgPublisherProviderData thatp = (FedMsgPublisherProviderData)that;
        return (this.name != null ? this.name.equals(thatp.name) : thatp.name == null) && (this.overrides != null ? this.overrides.equals(thatp.overrides) : thatp.overrides == null) && (this.messageContent != null ? this.messageContent.equals(thatp.messageContent) : thatp.messageContent == null) && (this.failOnError != null ? this.failOnError.equals(thatp.failOnError) : thatp.failOnError == null);
    }

    @Extension
    public static class FedMsgPublisherProviderDataDescriptor
    extends ProviderData.ProviderDataDescriptor {
        public String getDisplayName() {
            return "FedMsg Publisher Provider Data";
        }

        public FedMsgPublisherProviderData newInstance(StaplerRequest sr, JSONObject jo) {
            MessagingProviderOverrides mpo = null;
            if (!jo.getJSONObject("overrides").isNullObject()) {
                mpo = new MessagingProviderOverrides(jo.getJSONObject("overrides").getString("topic"));
            }
            return new FedMsgPublisherProviderData(jo.getString("name"), mpo, jo.getString("messageContent"), jo.getBoolean("failOnError"));
        }

        public String getConfigPage() {
            return "fedmsg-publisher.jelly";
        }
    }
}

