/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.provider.data;

import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import com.redhat.utils.MessageUtils;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ActiveMQPublisherProviderData
extends ActiveMQProviderData {
    private static final long serialVersionUID = -2179136605130421113L;
    public static final MessageUtils.MESSAGE_TYPE DEFAULT_MESSAGE_TYPE = MessageUtils.MESSAGE_TYPE.Custom;
    private MessageUtils.MESSAGE_TYPE messageType;
    private String messageProperties;
    private String messageContent;
    private Boolean failOnError = false;

    @DataBoundConstructor
    public ActiveMQPublisherProviderData() {
    }

    public ActiveMQPublisherProviderData(String name) {
        this(name, null);
    }

    public ActiveMQPublisherProviderData(String name, MessagingProviderOverrides overrides) {
        super(name, overrides);
    }

    public ActiveMQPublisherProviderData(String name, MessagingProviderOverrides overrides, MessageUtils.MESSAGE_TYPE messageType, String messageProperties, String messageContent, Boolean failOnError) {
        this(name, overrides);
        this.messageType = messageType;
        this.messageProperties = messageProperties;
        this.messageContent = messageContent;
        this.failOnError = failOnError;
    }

    public MessageUtils.MESSAGE_TYPE getMessageType() {
        return this.messageType;
    }

    @DataBoundSetter
    public void setMessageType(MessageUtils.MESSAGE_TYPE messageType) {
        this.messageType = messageType;
    }

    public String getMessageProperties() {
        return this.messageProperties;
    }

    @DataBoundSetter
    public void setMessageProperties(String messageProperties) {
        this.messageProperties = messageProperties;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    @DataBoundSetter
    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public Boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public Descriptor<ProviderData> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(ActiveMQPublisherProviderDataDescriptor.class);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        ActiveMQPublisherProviderData thatp = (ActiveMQPublisherProviderData)that;
        return (this.name != null ? this.name.equals(thatp.name) : thatp.name == null) && (this.overrides != null ? this.overrides.equals(thatp.overrides) : thatp.overrides == null) && (this.messageType != null ? this.messageType.equals((Object)thatp.messageType) : thatp.messageType == null) && (this.messageProperties != null ? this.messageProperties.equals(thatp.messageProperties) : thatp.messageProperties == null) && (this.messageContent != null ? this.messageContent.equals(thatp.messageContent) : thatp.messageContent == null) && (this.failOnError != null ? this.failOnError.equals(thatp.failOnError) : thatp.failOnError == null);
    }

    @Extension
    public static class ActiveMQPublisherProviderDataDescriptor
    extends ProviderData.ProviderDataDescriptor {
        public String getDisplayName() {
            return "ActiveMQ Publisher Provider Data";
        }

        public ActiveMQPublisherProviderData newInstance(StaplerRequest sr, JSONObject jo) {
            MessagingProviderOverrides mpo = null;
            if (!jo.getJSONObject("overrides").isNullObject()) {
                mpo = new MessagingProviderOverrides(jo.getJSONObject("overrides").getString("topic"));
            }
            return new ActiveMQPublisherProviderData(jo.getString("name"), mpo, MessageUtils.MESSAGE_TYPE.fromString(jo.getString("messageType")), jo.getString("messageProperties"), jo.getString("messageContent"), jo.getBoolean("failOnError"));
        }

        public ListBoxModel doFillMessageTypeItems(@QueryParameter String messageType) {
            MessageUtils.MESSAGE_TYPE current = MessageUtils.MESSAGE_TYPE.fromString(messageType);
            ListBoxModel items = new ListBoxModel();
            for (MessageUtils.MESSAGE_TYPE t : MessageUtils.MESSAGE_TYPE.values()) {
                items.add((Object)new ListBoxModel.Option(t.toDisplayName(), t.name(), t == current || items.size() == 0));
            }
            return items;
        }

        public MessageUtils.MESSAGE_TYPE getDefaultMessageType() {
            return DEFAULT_MESSAGE_TYPE;
        }

        public String getConfigPage() {
            return "amq-publisher.jelly";
        }
    }
}

