/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.pipeline;

import com.google.common.collect.ImmutableSet;
import com.redhat.jenkins.plugins.ci.CIMessageSubscriberBuilder;
import com.redhat.jenkins.plugins.ci.GlobalCIConfiguration;
import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.FedMsgMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.MessagingProviderOverrides;
import com.redhat.jenkins.plugins.ci.messaging.checks.MsgCheck;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQSubscriberProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgSubscriberProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class CIMessageSubscriberStep
extends Step {
    private String providerName;
    private MessagingProviderOverrides overrides;
    private String selector;
    private List<MsgCheck> checks = new ArrayList<MsgCheck>();
    private Integer timeout;

    @DataBoundConstructor
    public CIMessageSubscriberStep(String providerName, MessagingProviderOverrides overrides, String selector, Integer timeout, List<MsgCheck> checks) {
        this.providerName = providerName;
        this.overrides = overrides;
        this.selector = selector;
        this.timeout = timeout;
        if (checks == null) {
            checks = new ArrayList<MsgCheck>();
        }
        this.checks = checks;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public MessagingProviderOverrides getOverrides() {
        return this.overrides;
    }

    public void setOverrides(MessagingProviderOverrides overrides) {
        this.overrides = overrides;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public List<MsgCheck> getChecks() {
        return this.checks;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public ListBoxModel doFillProviderNameItems() {
            ListBoxModel items = new ListBoxModel();
            for (JMSMessagingProvider provider : GlobalCIConfiguration.get().getConfigs()) {
                items.add(provider.getName());
            }
            return items;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, Launcher.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "waitForCIMessage";
        }

        public String getDisplayName() {
            return Messages.SubscriberBuilder();
        }
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        @Inject
        private transient CIMessageSubscriberStep step;
        private transient Future<?> task;
        private static final long serialVersionUID = 1L;

        Execution(CIMessageSubscriberStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            if (this.step.getProviderName() == null) {
                throw new Exception("providerName not specified!");
            }
            this.task = Timer.get().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProviderData pd = null;
                        JMSMessagingProvider p = GlobalCIConfiguration.get().getProvider(Execution.this.step.getProviderName());
                        if (p instanceof ActiveMqMessagingProvider) {
                            ActiveMQSubscriberProviderData apd = new ActiveMQSubscriberProviderData(Execution.this.step.getProviderName());
                            apd.setOverrides(Execution.this.step.getOverrides());
                            apd.setSelector(Execution.this.step.getSelector());
                            apd.setChecks(Execution.this.step.getChecks());
                            apd.setTimeout(Execution.this.step.getTimeout());
                            pd = apd;
                        } else if (p instanceof FedMsgMessagingProvider) {
                            FedMsgSubscriberProviderData fpd = new FedMsgSubscriberProviderData(Execution.this.step.getProviderName());
                            fpd.setOverrides(Execution.this.step.getOverrides());
                            fpd.setChecks(Execution.this.step.getChecks());
                            fpd.setTimeout(Execution.this.step.getTimeout());
                            pd = fpd;
                        }
                        CIMessageSubscriberBuilder subscriber = new CIMessageSubscriberBuilder(pd);
                        StepContext c = Execution.this.getContext();
                        String result = subscriber.waitforCIMessage((Run)c.get(Run.class), (Launcher)c.get(Launcher.class), (TaskListener)c.get(TaskListener.class));
                        if (result != null) {
                            Execution.this.getContext().onSuccess((Object)result);
                        } else {
                            Execution.this.getContext().onFailure((Throwable)new AbortException("Timeout waiting for message!"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Execution.this.getContext().onFailure((Throwable)e);
                    }
                }
            });
            return false;
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            if (this.task != null) {
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("in stop of watcher");
                this.task.cancel(true);
                this.getContext().onFailure(cause);
            }
        }
    }
}

