/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging.topics;

import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.IOException;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class TopicProvider
implements Describable<TopicProvider>,
Serializable {
    private static final long serialVersionUID = -5505891184928466956L;

    public static abstract class TopicProviderDescriptor
    extends Descriptor<TopicProvider> {
        public abstract String generatePublisherTopic();

        public abstract String generateSubscriberTopic();

        public void doGeneratePublisherTopic(StaplerRequest req, StaplerResponse resp) throws IOException {
            String topic = this.generatePublisherTopic();
            resp.getWriter().write(topic != null ? topic : "");
        }

        public void doGenerateSubscriberTopic(StaplerRequest req, StaplerResponse resp) throws IOException {
            String topic = this.generateSubscriberTopic();
            resp.getWriter().write(topic != null ? topic : "");
        }

        public static ExtensionList<TopicProviderDescriptor> all() {
            return Jenkins.getInstance().getExtensionList(TopicProviderDescriptor.class);
        }
    }
}

