/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(alphabetic=true)
public class FedmsgMessage {
    private static final Logger log = Logger.getLogger(FedmsgMessage.class.getName());
    private long timestamp;
    private String topic;
    private String msgId;
    @JsonProperty(value="msg")
    private Map<String, Object> msg = null;

    public FedmsgMessage() {
    }

    public FedmsgMessage(String topic) {
        this(topic, null);
    }

    public FedmsgMessage(String topic, String body) {
        this.topic = topic;
        this.msgId = Integer.toString(Calendar.getInstance().get(1)) + "-" + UUID.randomUUID().toString();
        if (!StringUtils.isBlank((CharSequence)body)) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
                this.msg = (Map)mapper.readValue(body, (TypeReference)typeRef);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to deserialize message body.", e);
            }
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp);
    }

    @JsonProperty(value="msg_id")
    public final String getMsgId() {
        return this.msgId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, Object> getMsg() {
        return this.msg;
    }

    public void setMsg(Map<String, Object> msg) {
        this.msg = msg;
    }

    @JsonIgnore
    public String getBodyJson() {
        if (this.msg != null) {
            return JSONObject.fromObject(this.msg).toString();
        }
        return "";
    }

    public String toJson() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writer();
            writer.with(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).writeValue((OutputStream)os, (Object)this);
            os.close();
            return new String(os.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

