/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging;

import com.redhat.jenkins.plugins.ci.messaging.FedMsgMessageWatcher;
import com.redhat.jenkins.plugins.ci.messaging.FedMsgMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessageWatcher;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.data.FedmsgMessage;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.Extension;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class FedMsgMessagingProvider
extends JMSMessagingProvider {
    private static final long serialVersionUID = 82154526798596907L;
    private String hubAddr;
    private String pubAddr;
    private String topic;

    @DataBoundConstructor
    public FedMsgMessagingProvider(String name, String hubAddr, String pubAddr, String topic) {
        this.name = name;
        this.hubAddr = hubAddr;
        this.pubAddr = pubAddr;
        this.topic = topic;
    }

    public String getHubAddr() {
        return this.hubAddr;
    }

    public String petHubAddr() {
        return this.pubAddr;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public String formatMessage(FedmsgMessage data) {
        return data.getBodyJson();
    }

    @Override
    public JMSMessagingWorker createWorker(ProviderData pdata, String jobname) {
        return new FedMsgMessagingWorker(this, ((FedMsgProviderData)pdata).getOverrides(), jobname);
    }

    @Override
    public JMSMessageWatcher createWatcher() {
        return new FedMsgMessageWatcher();
    }

    public Descriptor<JMSMessagingProvider> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(FedMsgMessagingProviderDescriptor.class);
    }

    public String getPubAddr() {
        return this.pubAddr;
    }

    @Extension
    public static class FedMsgMessagingProviderDescriptor
    extends JMSMessagingProvider.MessagingProviderDescriptor {
        public String getDisplayName() {
            return "FedMsg";
        }
    }
}

