/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.jenkins.plugins.ci.messaging.FedMsgMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessageWatcher;
import com.redhat.jenkins.plugins.ci.messaging.checks.MsgCheck;
import com.redhat.jenkins.plugins.ci.messaging.data.FedmsgMessage;
import com.redhat.utils.PluginUtils;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class FedMsgMessageWatcher
extends JMSMessageWatcher {
    private static final Logger log = Logger.getLogger(FedMsgMessageWatcher.class.getName());
    private ZMQ.Context lcontext;
    private ZMQ.Poller lpoller;
    private ZMQ.Socket lsocket;
    private String topic;
    private FedMsgMessagingProvider fedMsgMessagingProvider;
    private boolean interrupted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String watch() {
        this.fedMsgMessagingProvider = (FedMsgMessagingProvider)this.provider;
        log.info("Waiting for message with selector: " + this.selector);
        for (MsgCheck msgCheck : this.checks) {
            log.info(" with check: " + msgCheck.toString());
        }
        this.taskListener.getLogger().println("Waiting for message with selector: " + this.selector);
        for (MsgCheck msgCheck : this.checks) {
            this.taskListener.getLogger().println(" with check: " + msgCheck.toString());
        }
        log.info(" with timeout: " + this.timeout);
        this.taskListener.getLogger().println(" with timeout: " + this.timeout);
        this.lcontext = ZMQ.context((int)1);
        this.lpoller = this.lcontext.poller(1);
        this.lsocket = this.lcontext.socket(2);
        this.topic = PluginUtils.getSubstitutedValue(FedMsgMessageWatcher.getTopic(this.overrides, this.fedMsgMessagingProvider.getTopic(), "org.fedoraproject"), this.environment);
        this.lsocket.subscribe(this.topic.getBytes());
        this.lsocket.setLinger(0L);
        this.lsocket.connect(this.fedMsgMessagingProvider.getHubAddr());
        this.lpoller.register(this.lsocket, 1);
        ObjectMapper mapper = new ObjectMapper();
        long startTime = new Date().getTime();
        int timeoutInMs = this.timeout * 60 * 1000;
        this.interrupted = false;
        try {
            ZMsg z;
            while (new Date().getTime() - startTime < (long)timeoutInMs) {
                String json;
                FedmsgMessage data;
                if (this.lpoller.poll(1000L) <= 0 || !this.lpoller.pollin(0) || !this.provider.verify((data = (FedmsgMessage)mapper.readValue(json = (z = ZMsg.recvMsg((ZMQ.Socket)this.lpoller.getSocket(0))).getLast().toString(), FedmsgMessage.class)).getBodyJson(), this.checks)) continue;
                String string = data.getBodyJson();
                return string;
            }
            if (this.interrupted) {
                z = null;
                return z;
            }
            log.severe("Timed out waiting for message!");
            this.taskListener.getLogger().println("Timed out waiting for message!");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unhandled exception waiting for message.", e);
        }
        finally {
            try {
                if (this.lpoller != null) {
                    ZMQ.Socket s = this.lpoller.getSocket(0);
                    this.lpoller.unregister(s);
                    s.disconnect(this.fedMsgMessagingProvider.getHubAddr());
                    this.lsocket.unsubscribe(this.topic.getBytes());
                    this.lsocket.close();
                }
                if (this.lcontext != null) {
                    this.lcontext.term();
                }
            }
            catch (Exception e) {
                log.fine(e.getMessage());
            }
            this.lpoller = null;
            this.lsocket = null;
        }
        return null;
    }

    @Override
    public void interrupt() {
        log.severe("start interrupt");
        this.taskListener.getLogger().println("start interrupt");
        this.interrupted = true;
        try {
            if (this.lpoller != null) {
                ZMQ.Socket s = this.lpoller.getSocket(0);
                this.lpoller.unregister(s);
                s.disconnect(this.fedMsgMessagingProvider.getHubAddr());
                this.lsocket.unsubscribe(this.topic.getBytes());
                this.lsocket.close();
            }
            if (this.lcontext != null) {
                this.lcontext.term();
            }
            log.severe("term done");
            this.taskListener.getLogger().println("term done");
        }
        catch (Exception e) {
            log.fine(e.getMessage());
        }
        this.lpoller = null;
        this.lsocket = null;
        this.interrupted = false;
    }
}

