/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging;

import com.redhat.jenkins.plugins.ci.authentication.AuthenticationMethod;
import com.redhat.jenkins.plugins.ci.authentication.activemq.ActiveMQAuthenticationMethod;
import com.redhat.jenkins.plugins.ci.authentication.activemq.UsernameAuthenticationMethod;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessageWatcher;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessageWatcher;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.topics.DefaultTopicProvider;
import com.redhat.jenkins.plugins.ci.messaging.topics.TopicProvider;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ActiveMqMessagingProvider
extends JMSMessagingProvider {
    private static final long serialVersionUID = -5710867670450057616L;
    private static final boolean DEFAULT_USE_QUEUES = false;
    private String broker;
    private Boolean useQueues = false;
    private transient String user;
    private transient Secret password;
    private transient boolean migrationInProgress = false;
    private TopicProvider topicProvider = new DefaultTopicProvider();
    private ActiveMQAuthenticationMethod authenticationMethod;
    private static final transient Logger log = Logger.getLogger(ActiveMqMessagingProvider.class.getName());

    @DataBoundConstructor
    public ActiveMqMessagingProvider(String name, String broker, Boolean useQueues, String topic, TopicProvider topicProvider, ActiveMQAuthenticationMethod authenticationMethod) {
        this.name = name;
        this.broker = broker;
        this.useQueues = useQueues;
        this.topic = topic;
        this.topicProvider = topicProvider;
        this.authenticationMethod = authenticationMethod;
    }

    protected Object readResolve() {
        if (this.user != null) {
            log.info("Legacy Message Provider username value is not null.");
            this.authenticationMethod = new UsernameAuthenticationMethod(this.user, this.password);
            log.info("Added default username/password authentication method using deprecated configuration.");
            this.setMigrationInProgress(true);
        }
        if (this.topicProvider == null) {
            this.topicProvider = new DefaultTopicProvider();
            this.setMigrationInProgress(true);
        }
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setBroker(String broker) {
        this.broker = StringUtils.strip((String)StringUtils.stripToNull((String)broker), (String)"/");
    }

    @DataBoundSetter
    public void setUseQueues(Boolean useQueues) {
        this.useQueues = useQueues;
    }

    @DataBoundSetter
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @DataBoundSetter
    public void setTopicProvider(TopicProvider topicProvider) {
        this.topicProvider = topicProvider;
    }

    @DataBoundSetter
    public void setAuthenticationMethod(ActiveMQAuthenticationMethod method) {
        this.authenticationMethod = method;
    }

    public Descriptor<JMSMessagingProvider> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(ActiveMqMessagingProviderDescriptor.class);
    }

    public String getBroker() {
        return this.broker;
    }

    public Boolean getUseQueues() {
        return this.useQueues != null ? this.useQueues : false;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public TopicProvider getTopicProvider() {
        return this.topicProvider;
    }

    public ActiveMQAuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.getConnectionFactory(this.getBroker(), this.getAuthenticationMethod());
    }

    public ActiveMQConnectionFactory getConnectionFactory(String broker, ActiveMQAuthenticationMethod authenticationMethod) {
        return authenticationMethod.getConnectionFactory(broker);
    }

    @Override
    public JMSMessagingWorker createWorker(ProviderData pdata, String jobname) {
        return new ActiveMqMessagingWorker(this, ((ActiveMQProviderData)pdata).getOverrides(), jobname);
    }

    @Override
    public JMSMessageWatcher createWatcher() {
        return new ActiveMqMessageWatcher();
    }

    public boolean IsMigrationInProgress() {
        return this.migrationInProgress;
    }

    private void setMigrationInProgress(boolean migrationInProgress) {
        this.migrationInProgress = migrationInProgress;
    }

    @Extension
    public static class ActiveMqMessagingProviderDescriptor
    extends JMSMessagingProvider.MessagingProviderDescriptor {
        private final Logger log = Logger.getLogger(ActiveMqMessagingProviderDescriptor.class.getName());

        public String getDisplayName() {
            return "Active MQ";
        }

        public ExtensionList<TopicProvider.TopicProviderDescriptor> getTopicProviderDescriptors() {
            return TopicProvider.TopicProviderDescriptor.all();
        }

        public ExtensionList<AuthenticationMethod.AuthenticationMethodDescriptor> getAuthenticationMethodDescriptors() {
            return AuthenticationMethod.AuthenticationMethodDescriptor.all();
        }
    }
}

