/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.messaging;

import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingWorker;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessageWatcher;
import com.redhat.utils.PluginUtils;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ActiveMqMessageWatcher
extends JMSMessageWatcher {
    private static final Logger log = Logger.getLogger(ActiveMqMessageWatcher.class.getName());
    private ActiveMqMessagingProvider activeMqMessagingProvider;
    private String topic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String watch() {
        this.activeMqMessagingProvider = (ActiveMqMessagingProvider)this.provider;
        String ip = null;
        try {
            ip = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.severe("Unable to get localhost IP address.");
        }
        this.topic = PluginUtils.getSubstitutedValue(ActiveMqMessageWatcher.getTopic(this.overrides, this.activeMqMessagingProvider.getTopic(), null), this.environment);
        if (ip != null && this.activeMqMessagingProvider.getAuthenticationMethod() != null && this.topic != null && this.activeMqMessagingProvider.getBroker() != null) {
            log.info("Waiting for message with selector: " + this.selector);
            this.taskListener.getLogger().println("Waiting for message with selector: " + this.selector);
            Connection connection = null;
            MessageConsumer consumer = null;
            try {
                Queue destination;
                ActiveMQConnectionFactory connectionFactory = this.activeMqMessagingProvider.getConnectionFactory();
                connection = connectionFactory.createConnection();
                connection.setClientID(ip + "_" + UUID.randomUUID().toString());
                connection.start();
                Session session = connection.createSession(false, 1);
                if (this.activeMqMessagingProvider.getUseQueues().booleanValue()) {
                    destination = session.createQueue(this.topic);
                    consumer = session.createConsumer((Destination)destination, this.selector, false);
                } else {
                    destination = session.createTopic(this.topic);
                    consumer = session.createDurableSubscriber((Topic)destination, UUID.randomUUID().toString(), this.selector, false);
                }
                Message message = consumer.receive((long)(this.timeout * 60 * 1000));
                if (message != null) {
                    String value = ActiveMqMessagingWorker.getMessageBody(message);
                    log.info("Received message with selector: " + this.selector + "\n" + ActiveMqMessagingWorker.formatMessage(message));
                    this.taskListener.getLogger().println("Received message with selector: " + this.selector + "\n" + ActiveMqMessagingWorker.formatMessage(message));
                    String string = value;
                    return string;
                }
                log.info("Timed out waiting for message!");
                this.taskListener.getLogger().println("Timed out waiting for message!");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unhandled exception waiting for message.", e);
            }
            finally {
                if (consumer != null) {
                    try {
                        consumer.close();
                    }
                    catch (Exception exception) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            log.severe("One or more of the following is invalid (null): ip, user, password, topic, broker.");
        }
        return null;
    }

    @Override
    public void interrupt() {
    }
}

