/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.authentication.activemq;

import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.authentication.AuthenticationMethod;
import com.redhat.jenkins.plugins.ci.authentication.activemq.ActiveMQAuthenticationMethod;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class UsernameAuthenticationMethod
extends ActiveMQAuthenticationMethod {
    private static final long serialVersionUID = 452156745621333923L;
    private static final transient Logger log = Logger.getLogger(UsernameAuthenticationMethod.class.getName());
    private String username;
    private Secret password;

    @DataBoundConstructor
    public UsernameAuthenticationMethod(String username, Secret password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    public Secret getPassword() {
        return this.password;
    }

    @DataBoundSetter
    public void setPassword(Secret password) {
        this.password = password;
    }

    @Override
    public ActiveMQConnectionFactory getConnectionFactory(String broker) {
        return new ActiveMQConnectionFactory(this.getUsername(), this.getPassword().getPlainText(), broker);
    }

    public Descriptor<AuthenticationMethod> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(UsernameAuthenticationMethodDescriptor.class);
    }

    @Extension
    public static class UsernameAuthenticationMethodDescriptor
    extends AuthenticationMethod.AuthenticationMethodDescriptor {
        public String getDisplayName() {
            return "Username and Password Authentication";
        }

        public UsernameAuthenticationMethod newInstance(StaplerRequest sr, JSONObject jo) {
            return new UsernameAuthenticationMethod(jo.getString("user"), Secret.fromString((String)jo.getString("password")));
        }

        public String getConfigPage() {
            return "username.jelly";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestConnection(@QueryParameter(value="broker") String broker, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) throws ServletException {
            broker = StringUtils.strip((String)StringUtils.stripToNull((String)broker), (String)"/");
            Session session = null;
            Connection connection = null;
            if (broker != null && UsernameAuthenticationMethodDescriptor.isValidURL(broker)) {
                try {
                    UsernameAuthenticationMethod uam = new UsernameAuthenticationMethod(username, Secret.fromString((String)password));
                    ActiveMQConnectionFactory connectionFactory = uam.getConnectionFactory(broker);
                    connection = connectionFactory.createConnection();
                    connection.start();
                    session = connection.createSession(false, 1);
                    session.close();
                    connection.close();
                    FormValidation formValidation = FormValidation.ok((String)Messages.SuccessBrokerConnect(broker));
                    return formValidation;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unhandled exception in UsernameAuthenticationMethod.doTestConnection: ", e);
                    FormValidation formValidation = FormValidation.error((String)(Messages.Error() + ": " + e));
                    return formValidation;
                }
                finally {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (JMSException jMSException) {}
                }
            }
            return FormValidation.error((String)Messages.InvalidURI());
        }
    }
}

