/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci.authentication.activemq;

import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.authentication.AuthenticationMethod;
import com.redhat.jenkins.plugins.ci.authentication.activemq.ActiveMQAuthenticationMethod;
import com.redhat.utils.PluginUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SSLCertificateAuthenticationMethod
extends ActiveMQAuthenticationMethod {
    private static final long serialVersionUID = -5934219869726669459L;
    private static final transient Logger log = Logger.getLogger(SSLCertificateAuthenticationMethod.class.getName());
    private String keystore;
    private Secret keypwd = Secret.fromString((String)"");
    private String truststore;
    private Secret trustpwd = Secret.fromString((String)"");

    @DataBoundConstructor
    public SSLCertificateAuthenticationMethod(String keystore, Secret keypwd, String truststore, Secret trustpwd) {
        this.setKeystore(keystore);
        this.setKeypwd(keypwd);
        this.setTruststore(truststore);
        this.setTrustpwd(trustpwd);
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public Secret getKeypwd() {
        return this.keypwd;
    }

    public void setKeypwd(Secret password) {
        this.keypwd = password;
    }

    private String getSubstitutedValue(String value) {
        EnvVars vars = new EnvVars();
        vars.put("JENKINS_HOME", Jenkins.getInstance().getRootDir().toString());
        return PluginUtils.getSubstitutedValue(value, vars);
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public Secret getTrustpwd() {
        return this.trustpwd;
    }

    public void setTrustpwd(Secret trustpwd) {
        this.trustpwd = trustpwd;
    }

    public ActiveMQSslConnectionFactory getConnectionFactory(String broker) {
        try {
            ActiveMQSslConnectionFactory connectionFactory = new ActiveMQSslConnectionFactory(broker);
            connectionFactory.setKeyStore(this.getSubstitutedValue(this.getKeystore()));
            connectionFactory.setKeyStorePassword(Secret.toString((Secret)this.getKeypwd()));
            connectionFactory.setTrustStore(this.getSubstitutedValue(this.getTruststore()));
            connectionFactory.setTrustStorePassword(Secret.toString((Secret)this.getTrustpwd()));
            return connectionFactory;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unhandled exception creating connection factory.", e);
            return null;
        }
    }

    public Descriptor<AuthenticationMethod> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(SSLCertificateAuthenticationMethodDescriptor.class);
    }

    @Extension
    public static class SSLCertificateAuthenticationMethodDescriptor
    extends AuthenticationMethod.AuthenticationMethodDescriptor {
        public String getDisplayName() {
            return "SSL Certificate Authentication";
        }

        public SSLCertificateAuthenticationMethod newInstance(StaplerRequest sr, JSONObject jo) {
            return new SSLCertificateAuthenticationMethod(jo.getString("keystore"), Secret.fromString((String)jo.getString("keypwd")), jo.getString("truststore"), Secret.fromString((String)jo.getString("trustpwd")));
        }

        public String getConfigPage() {
            return "sslcert.jelly";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestConnection(@QueryParameter(value="broker") String broker, @QueryParameter(value="keystore") String keystore, @QueryParameter(value="keypwd") String keypwd, @QueryParameter(value="truststore") String truststore, @QueryParameter(value="trustpwd") String trustpwd) throws ServletException {
            broker = StringUtils.strip((String)StringUtils.stripToNull((String)broker), (String)"/");
            Connection connection = null;
            Session session = null;
            if (broker != null && SSLCertificateAuthenticationMethodDescriptor.isValidURL(broker)) {
                try {
                    SSLCertificateAuthenticationMethod sam = new SSLCertificateAuthenticationMethod(keystore, Secret.fromString((String)keypwd), truststore, Secret.fromString((String)trustpwd));
                    ActiveMQSslConnectionFactory connectionFactory = sam.getConnectionFactory(broker);
                    connection = connectionFactory.createConnection();
                    connection.start();
                    session = connection.createSession(false, 1);
                    session.close();
                    connection.close();
                    FormValidation formValidation = FormValidation.ok((String)Messages.SuccessBrokerConnect(broker));
                    return formValidation;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unhandled exception in SSLCertificateAuthenticationMethod.doTestConnection: ", e);
                    FormValidation formValidation = FormValidation.error((String)(Messages.Error() + ": " + e));
                    return formValidation;
                }
                finally {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (JMSException jMSException) {}
                }
            }
            return FormValidation.error((String)Messages.InvalidURI());
        }
    }
}

