/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci;

import com.redhat.jenkins.plugins.ci.Messages;
import com.redhat.jenkins.plugins.ci.authentication.activemq.UsernameAuthenticationMethod;
import com.redhat.jenkins.plugins.ci.messaging.ActiveMqMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.topics.DefaultTopicProvider;
import com.redhat.jenkins.plugins.ci.messaging.topics.TopicProvider;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQPublisherProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ActiveMQSubscriberProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgPublisherProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.FedMsgSubscriberProviderData;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class GlobalCIConfiguration
extends GlobalConfiguration {
    public static final String DEFAULT_PROVIDER = "default";
    private transient String broker;
    private transient String topic;
    private transient String user;
    private transient Secret password;
    private transient boolean migrationInProgress = false;
    private List<JMSMessagingProvider> configs = new ArrayList<JMSMessagingProvider>();
    public static final String CONTENT_NONE = "-";
    private static final Logger log = Logger.getLogger(GlobalCIConfiguration.class.getName());

    public boolean isMigrationInProgress() {
        return this.migrationInProgress;
    }

    private void setMigrationInProgress(boolean migrationInProgress) {
        this.migrationInProgress = migrationInProgress;
    }

    public GlobalCIConfiguration(List<JMSMessagingProvider> configs) {
        this.configs = configs;
    }

    @DataBoundConstructor
    public GlobalCIConfiguration() {
        this.load();
    }

    protected Object readResolve() {
        if (this.broker != null) {
            log.info("Legacy Message Provider Broker value is not null.");
            if (this.configs.size() == 0) {
                log.info("Current Message Provider size is 0.");
                if (this.getProvider(DEFAULT_PROVIDER) == null) {
                    log.info("There is no default Message Provider.");
                    this.configs.add(new ActiveMqMessagingProvider(DEFAULT_PROVIDER, this.broker, false, this.topic, new DefaultTopicProvider(), new UsernameAuthenticationMethod(this.user, this.password)));
                    log.info("Added default Message Provider using deprecated configuration.");
                    this.setMigrationInProgress(true);
                } else {
                    log.info("Default (default) Message Provider already exists.");
                }
            }
        }
        if (this.configs != null) {
            for (JMSMessagingProvider config : this.configs) {
                ActiveMqMessagingProvider aconfig;
                if (!(config instanceof ActiveMqMessagingProvider) || !(aconfig = (ActiveMqMessagingProvider)config).IsMigrationInProgress()) continue;
                log.info("Migration in progress for ActiveMqMessagingProvider " + aconfig.getName());
                this.setMigrationInProgress(true);
            }
        }
        return this;
    }

    @DataBoundSetter
    public void setConfigs(List<JMSMessagingProvider> configs) {
        this.configs = configs;
    }

    public List<JMSMessagingProvider> getConfigs() {
        return Collections.unmodifiableList(this.configs);
    }

    public boolean addMessageProvider(JMSMessagingProvider provider) {
        if (this.configs == null) {
            this.configs = new ArrayList<JMSMessagingProvider>();
        }
        if (this.configs.contains(provider)) {
            throw new Failure("Attempt to add a duplicate message provider");
        }
        this.configs.add(provider);
        return true;
    }

    public JMSMessagingProvider getProvider(String name) {
        for (JMSMessagingProvider provider : this.getConfigs()) {
            if (!provider.getName().equals(name)) continue;
            return provider;
        }
        return null;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        HashMap<String, String> names = new HashMap<String, String>();
        Object obj = json.get("configs");
        if (obj instanceof JSONArray) {
            JSONArray arr = (JSONArray)obj;
            for (Object obj2 : arr) {
                JSONObject providerObj = (JSONObject)obj2;
                String name = providerObj.getString("name");
                if (names.containsKey(name)) {
                    throw new Failure("Attempt to add a duplicate JMS Message Provider - " + name);
                }
                names.put(name, name);
            }
        }
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public String getDisplayName() {
        return Messages.PluginName();
    }

    @Nonnull
    public static GlobalCIConfiguration get() {
        ExtensionList all = GlobalConfiguration.all();
        GlobalCIConfiguration c = (GlobalCIConfiguration)((Object)all.get(GlobalCIConfiguration.class));
        if (c == null) {
            GlobalConfiguration registered = (GlobalConfiguration)all.getDynamic(GlobalCIConfiguration.class.getCanonicalName());
            if (registered != null) {
                PluginManager pm = Jenkins.getInstance().pluginManager;
                PluginWrapper source = pm.whichPlugin(registered.getClass());
                throw new AssertionError((Object)("Version mismatch: GlobalCIConfiguration provided by other plugin: " + source));
            }
            throw new AssertionError((Object)("GlobalCIConfiguration is not registered: " + all));
        }
        return c;
    }

    public Boolean getFirstProviderOverrides() {
        JMSMessagingProvider prov;
        if (this.configs != null && this.configs.size() > 0 && (prov = this.configs.get(0)) instanceof ActiveMqMessagingProvider && !(((ActiveMqMessagingProvider)prov).getTopicProvider() instanceof DefaultTopicProvider)) {
            return true;
        }
        return false;
    }

    public String getFirstProviderName() {
        if (this.configs != null && this.configs.size() > 0) {
            JMSMessagingProvider prov = this.configs.get(0);
            return prov.getName();
        }
        return "";
    }

    public String getFirstProviderOverrideTopic(String type) {
        JMSMessagingProvider prov;
        if (this.configs != null && this.configs.size() > 0 && (prov = this.configs.get(0)) instanceof ActiveMqMessagingProvider) {
            TopicProvider.TopicProviderDescriptor tpd = (TopicProvider.TopicProviderDescriptor)((ActiveMqMessagingProvider)prov).getTopicProvider().getDescriptor();
            if (type.equals("subscriber")) {
                return tpd.generateSubscriberTopic();
            }
            if (type.equals("publisher")) {
                return tpd.generatePublisherTopic();
            }
            log.severe("Unknown topic provider type '" + type + "'.");
            return "<unknown>";
        }
        return "";
    }

    public String getFirstProviderDisplayName() {
        if (this.configs != null && this.configs.size() > 0) {
            JMSMessagingProvider prov = this.configs.get(0);
            return prov.getDescriptor().getDisplayName();
        }
        return null;
    }

    public List<ProviderData> getSubscriberProviders() {
        ArrayList<ProviderData> pds = new ArrayList<ProviderData>();
        if (this.configs != null) {
            for (JMSMessagingProvider p : this.getConfigs()) {
                if (p instanceof ActiveMqMessagingProvider) {
                    pds.add(new ActiveMQSubscriberProviderData(p.getName()));
                    continue;
                }
                pds.add(new FedMsgSubscriberProviderData(p.getName()));
            }
        }
        return pds;
    }

    public List<ProviderData> getPublisherProviders() {
        ArrayList<ProviderData> pds = new ArrayList<ProviderData>();
        if (this.configs != null) {
            for (JMSMessagingProvider p : this.getConfigs()) {
                if (p instanceof ActiveMqMessagingProvider) {
                    pds.add(new ActiveMQPublisherProviderData(p.getName()));
                    continue;
                }
                pds.add(new FedMsgPublisherProviderData(p.getName()));
            }
        }
        return pds;
    }
}

