/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jenkins.plugins.ci;

import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingProvider;
import com.redhat.jenkins.plugins.ci.messaging.JMSMessagingWorker;
import com.redhat.jenkins.plugins.ci.provider.data.ProviderData;
import hudson.security.ACL;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class CITriggerThread
extends Thread {
    private static final Logger log = Logger.getLogger(CITriggerThread.class.getName());
    private static final Integer WAIT_MINUTES = 60;
    private static final Integer WAIT_SECONDS = 2;
    private final JMSMessagingProvider messagingProvider;
    private final String jobname;
    private final ProviderData providerData;
    private final JMSMessagingWorker messagingWorker;

    public CITriggerThread(JMSMessagingProvider messagingProvider, ProviderData providerData, String jobname) {
        this.messagingProvider = messagingProvider;
        this.providerData = providerData;
        this.jobname = jobname;
        this.messagingWorker = messagingProvider.createWorker(providerData, this.jobname);
    }

    public void sendInterrupt() {
        this.messagingWorker.prepareForInterrupt();
    }

    @Override
    public void run() {
        SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            while (!Thread.currentThread().isInterrupted() && !this.messagingWorker.isBeingInterrupted()) {
                this.messagingWorker.receive(this.jobname, this.providerData);
            }
            log.info("Shutting down trigger thread for job '" + this.jobname + "'.");
            this.messagingWorker.unsubscribe(this.jobname);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    public boolean isMessageProviderConnected() {
        if (this.messagingWorker == null) {
            return false;
        }
        return this.messagingWorker.isConnectedAndSubscribed();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CITriggerThread thread = (CITriggerThread)o;
        return new EqualsBuilder().append((Object)this.messagingProvider, (Object)thread.messagingProvider).append((Object)this.providerData, (Object)thread.providerData).append((Object)this.jobname, (Object)thread.jobname).isEquals();
    }

    public int hashCode() {
        int result = this.messagingWorker != null ? this.messagingWorker.hashCode() : 0;
        result = 31 * result + (this.providerData != null ? this.providerData.hashCode() : 0);
        result = 31 * result + (this.jobname != null ? this.jobname.hashCode() : 0);
        return result;
    }
}

