/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.AbstractBuildParameters;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.filters.StringInputStream;
import org.kohsuke.stapler.DataBoundConstructor;

public class PredefinedBuildParameters
extends AbstractBuildParameters {
    private String jobProperties;

    @DataBoundConstructor
    public PredefinedBuildParameters(String jobProperties) {
        this.jobProperties = jobProperties;
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener, AbstractProject project) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment(listener);
        Properties pProp = new Properties();
        pProp.load((InputStream)new StringInputStream(this.jobProperties));
        LinkedHashMap<String, StringParameterValue> params = new LinkedHashMap<String, StringParameterValue>();
        for (Map.Entry<Object, Object> entry : pProp.entrySet()) {
            params.put(entry.getKey().toString(), new StringParameterValue(entry.getKey().toString(), env.expand(entry.getValue().toString())));
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    public String getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(String jobProperties) {
        this.jobProperties = jobProperties;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Predefined parameters";
        }
    }
}

