/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.Messages;
import com.tikal.jenkins.plugins.multijob.MultiJobResumeControl;
import com.tikal.jenkins.plugins.multijob.ResumeCause;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class MultiJobResumeBuild
implements RunAction2 {
    private final Run<?, ?> run;

    public MultiJobResumeBuild(Run<?, ?> run) {
        this.run = run;
    }

    public String getIconFileName() {
        return "plugin/jenkins-multijob-plugin/tool32.png";
    }

    public String getDisplayName() {
        return Messages.MultiJobResumeBuild_DisplayName();
    }

    public String getUrlName() {
        return "resume";
    }

    public String getInfo() {
        return "Resume build";
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        MultiJobResumeControl control = new MultiJobResumeControl(this.run);
        List<Action> actions = this.copyBuildCauses();
        actions.add(control);
        actions.add((Action)new CauseAction((Cause)new ResumeCause(this.run)));
        Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.run.getParent(), 0, actions);
        rsp.sendRedirect2(Jenkins.getInstance().getRootUrl() + this.run.getParent().getUrl());
    }

    public void onAttached(Run<?, ?> run) {
    }

    public void onLoad(Run<?, ?> run) {
    }

    private List<Action> copyBuildCauses() {
        ArrayList<Action> actions = new ArrayList<Action>();
        boolean hasUserIdCause = false;
        for (Object cause : this.run.getCauses()) {
            if (cause instanceof Cause.UserIdCause) {
                hasUserIdCause = true;
                actions.add((Action)new CauseAction((Cause)new Cause.UserIdCause()));
                continue;
            }
            actions.add((Action)new CauseAction((Cause)cause));
        }
        if (!hasUserIdCause) {
            actions.add((Action)new CauseAction((Cause)new Cause.UserIdCause()));
        }
        actions.addAll(this.run.getActions(ParametersAction.class));
        return actions;
    }
}

