/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.views.MultiJobView;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.PollingResult;
import hudson.util.AlternativeUiTextProvider;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class MultiJobProject
extends Project<MultiJobProject, MultiJobBuild>
implements TopLevelItem {
    private volatile boolean pollSubjobs = false;
    private volatile String resumeEnvVars = null;
    @Extension(ordinal=1000.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    private MultiJobProject(ItemGroup parent, String name) {
        super(parent, name);
    }

    public MultiJobProject(Hudson parent, String name) {
        super((ItemGroup)parent, name);
    }

    protected Class<MultiJobBuild> getBuildClass() {
        return MultiJobBuild.class;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)this.getDescriptor().getDisplayName());
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        super.buildDependencyGraph(graph);
    }

    public boolean isTopMost() {
        return this.getUpstreamProjects().size() == 0;
    }

    public MultiJobView getView() {
        return new MultiJobView("");
    }

    public String getRootUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    public PollingResult poll(TaskListener listener) {
        if (!this.getPollSubjobs()) {
            return super.poll(listener);
        }
        PollingResult result = super.poll(listener);
        if (result.hasChanges()) {
            return result;
        }
        List downProjs = this.getDownstreamProjects();
        PollingResult tmpResult = new PollingResult(PollingResult.Change.NONE);
        for (AbstractProject downProj : downProjs) {
            tmpResult = downProj.poll(listener);
            if (result.change.ordinal() >= tmpResult.change.ordinal() || !(result = tmpResult).hasChanges()) continue;
            return result;
        }
        return result;
    }

    public boolean getPollSubjobs() {
        return this.pollSubjobs;
    }

    public void setPollSubjobs(boolean poll) {
        this.pollSubjobs = poll;
    }

    public String getResumeEnvVars() {
        return this.resumeEnvVars;
    }

    public void setResumeEnvVars(String resumeEnvVars) {
        this.resumeEnvVars = resumeEnvVars;
    }

    public boolean getCheckResumeEnvVars() {
        return !StringUtils.isBlank((String)this.resumeEnvVars);
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        String k = "multijob";
        if (json.has(k)) {
            if ((json = json.getJSONObject(k)).has(k = "pollSubjobs")) {
                this.setPollSubjobs(json.optBoolean(k));
            }
            String resumeEnvVars = null;
            k = "resumeEnvVars";
            if (json.has(k) && (json = json.getJSONObject(k)).has(k)) {
                resumeEnvVars = json.getString(k);
            }
            this.setResumeEnvVars(resumeEnvVars);
        }
    }

    public static final class DescriptorImpl
    extends AbstractProject.AbstractProjectDescriptor {
        public String getDisplayName() {
            return "MultiJob Project";
        }

        public MultiJobProject newInstance(ItemGroup itemGroup, String name) {
            return new MultiJobProject(itemGroup, name);
        }
    }
}

