/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.LineQueue;
import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.MultiJobResumeControl;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import com.tikal.jenkins.plugins.multijob.StatusJob;
import com.tikal.jenkins.plugins.multijob.SubTask;
import com.tikal.jenkins.plugins.multijob.counters.CounterHelper;
import com.tikal.jenkins.plugins.multijob.counters.CounterManager;
import groovy.util.Eval;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectBuilderContributionAction;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class MultiJobBuilder
extends Builder
implements DependecyDeclarer {
    public static final String BUILD_ALWAYS_KEY = "hudson.scm.multijob.build.always";
    private String phaseName;
    private List<PhaseJobsConfig> phaseJobs;
    private ContinuationCondition continuationCondition = ContinuationCondition.SUCCESSFUL;
    private ExecutionType executionType;
    static final Pattern PATTERN = Pattern.compile("(\\$\\{.+?\\})", 2);
    public static final String JOB_STATUS = "JOB_STATUS";
    public static final String JOB_IS_BUILDABLE = "JOB_IS_BUILDABLE";
    public static final String PERSISTENT_VARS_PREFIX = "RESUMABLE_";

    @Deprecated
    public MultiJobBuilder(String phaseName, List<PhaseJobsConfig> phaseJobs, ContinuationCondition continuationCondition) {
        this(phaseName, phaseJobs, continuationCondition, ExecutionType.PARALLEL);
    }

    @DataBoundConstructor
    public MultiJobBuilder(String phaseName, List<PhaseJobsConfig> phaseJobs, ContinuationCondition continuationCondition, ExecutionType executionType) {
        this.phaseName = phaseName;
        this.phaseJobs = Util.fixNull(phaseJobs);
        this.continuationCondition = continuationCondition;
        this.executionType = executionType;
    }

    public String expandToken(String toExpand, AbstractBuild<?, ?> build, BuildListener listener) {
        String expandedExpression = toExpand;
        try {
            expandedExpression = TokenMacro.expandAll(build, (TaskListener)listener, (String)toExpand, (boolean)false, null);
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
        }
        return PATTERN.matcher(expandedExpression).replaceAll("");
    }

    private StatusJob getScmChange(AbstractProject subjob, PhaseJobsConfig phaseConfig, AbstractBuild build, BuildListener listener, Launcher launcher) throws IOException, InterruptedException {
        if (subjob.isDisabled()) {
            return StatusJob.IS_DISABLED;
        }
        if (phaseConfig.isDisableJob()) {
            return StatusJob.IS_DISABLED_AT_PHASECONFIG;
        }
        if (!phaseConfig.isBuildOnlyIfSCMChanges()) {
            return StatusJob.BUILD_ONLY_IF_SCM_CHANGES_DISABLED;
        }
        boolean buildAlways = Boolean.valueOf((String)build.getBuildVariables().get(BUILD_ALWAYS_KEY));
        if (buildAlways) {
            return StatusJob.BUILD_ALWAYS_IS_ENABLED;
        }
        AbstractBuild lastBuild = subjob.getLastBuild();
        if (lastBuild == null) {
            return StatusJob.DOESNT_CONTAINS_LASTBUILD;
        }
        if (lastBuild.getResult() != null && lastBuild.getResult().isWorseThan(Result.UNSTABLE)) {
            return StatusJob.LASTBUILD_RESULT_IS_WORSE_THAN_UNSTABLE;
        }
        if (!lastBuild.getWorkspace().exists()) {
            return StatusJob.WORKSPACE_IS_EMPTY;
        }
        if (subjob.poll((TaskListener)listener).hasChanges()) {
            return StatusJob.CHANGED_SINCE_LAST_BUILD;
        }
        return StatusJob.NOT_CHANGED_SINCE_LAST_BUILD;
    }

    public boolean evalCondition(String condition, AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            return (Boolean)Eval.me((String)this.expandToken(condition, build, listener).trim());
        }
        catch (Exception e) {
            listener.getLogger().println("Can't evaluate expression, false is assumed: " + e.toString());
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Result result;
        Item item;
        Jenkins jenkins = Jenkins.getInstance();
        MultiJobBuild multiJobBuild = (MultiJobBuild)build;
        MultiJobProject thisProject = (MultiJobProject)multiJobBuild.getProject();
        boolean resume = false;
        HashMap<String, MultiJobBuild.SubBuild> successBuildMap = new HashMap<String, MultiJobBuild.SubBuild>();
        HashMap<String, MultiJobBuild.SubBuild> resumeBuildMap = new HashMap<String, MultiJobBuild.SubBuild>();
        MultiJobResumeControl control = (MultiJobResumeControl)build.getAction(MultiJobResumeControl.class);
        if (null != control) {
            MultiJobBuild prevBuild = (MultiJobBuild)control.getRun();
            boolean willResumeBuild = true;
            if (thisProject.getCheckResumeEnvVars()) {
                String[] variables = thisProject.getResumeEnvVars().split(",");
                for (int i = 0; i < variables.length; ++i) {
                    String currentValue;
                    String previousValue = (String)prevBuild.getEnvironment((TaskListener)listener).get(variables[i]);
                    if (StringUtils.equals((String)previousValue, (String)(currentValue = (String)build.getEnvironment((TaskListener)listener).get(variables[i])))) continue;
                    willResumeBuild = false;
                    listener.getLogger().println(String.format("Cannot resume the build, values for '%s' do not match: [%s][%s]", variables[i], previousValue, currentValue));
                    break;
                }
            }
            if (willResumeBuild) {
                for (MultiJobBuild.SubBuild subBuild : prevBuild.getSubBuilds()) {
                    AbstractProject childProject;
                    AbstractBuild childBuild;
                    item = Jenkins.getInstance().getItem(subBuild.getJobName(), (Item)prevBuild.getParent(), AbstractProject.class);
                    if (!(item instanceof AbstractProject) || null == (childBuild = (childProject = (AbstractProject)item).getBuildByNumber(subBuild.getBuildNumber()))) continue;
                    if (Result.SUCCESS.equals(childBuild.getResult())) {
                        successBuildMap.put(childProject.getUrl(), subBuild);
                        continue;
                    }
                    resume = true;
                    resumeBuildMap.put(childProject.getUrl(), subBuild);
                }
            }
            if (!resume) {
                successBuildMap.clear();
            }
        }
        LinkedHashMap<PhaseSubJob, PhaseJobsConfig> phaseSubJobs = new LinkedHashMap<PhaseSubJob, PhaseJobsConfig>(this.phaseJobs.size());
        CounterManager phaseCounters = new CounterManager();
        for (PhaseJobsConfig phaseJobConfig : this.phaseJobs) {
            item = jenkins.getItem(phaseJobConfig.getJobName(), (Item)multiJobBuild.getParent(), AbstractProject.class);
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject job = (AbstractProject)item;
            phaseSubJobs.put(new PhaseSubJob(job), phaseJobConfig);
        }
        ArrayList<SubTask> subTasks = new ArrayList<SubTask>();
        int index = 0;
        for (PhaseSubJob phaseSubJob : phaseSubJobs.keySet()) {
            MultiJobBuild.SubBuild subBuild;
            boolean conditionExistsAndEvaluatedToTrue;
            StatusJob jobStatus;
            PhaseJobsConfig phaseConfig;
            AbstractProject subJob;
            block36: {
                ++index;
                subJob = phaseSubJob.job;
                phaseConfig = (PhaseJobsConfig)phaseSubJobs.get(phaseSubJob);
                jobStatus = this.getScmChange(subJob, phaseConfig, (AbstractBuild)multiJobBuild, listener, launcher);
                listener.getLogger().println(jobStatus.getMessage(subJob));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(JOB_STATUS, jobStatus.name());
                hashMap.put(JOB_IS_BUILDABLE, String.valueOf(jobStatus.isBuildable()));
                this.injectEnvVars(build, listener, hashMap);
                if (jobStatus == StatusJob.IS_DISABLED) {
                    phaseCounters.processSkipped();
                    continue;
                }
                conditionExistsAndEvaluatedToTrue = false;
                if (phaseConfig.getEnableCondition() && phaseConfig.getCondition() != null) {
                    if (jobStatus.isBuildable() && !phaseConfig.isApplyConditionOnlyIfNoSCMChanges()) {
                        if (this.evalCondition(phaseConfig.getCondition(), build, listener)) {
                            listener.getLogger().println(String.format("Triggering %s. Condition was evaluated to true.", subJob.getName()));
                            conditionExistsAndEvaluatedToTrue = true;
                            break block36;
                        } else {
                            listener.getLogger().println(String.format("Skipping %s. Condition was evaluated to false.", subJob.getName()));
                            phaseCounters.processSkipped();
                            continue;
                        }
                    }
                    if (!jobStatus.isBuildable() && phaseConfig.isApplyConditionOnlyIfNoSCMChanges()) {
                        if (this.evalCondition(phaseConfig.getCondition(), build, listener)) {
                            listener.getLogger().println(String.format("Triggering %s. Condition was evaluated to true.", subJob.getName()));
                            conditionExistsAndEvaluatedToTrue = true;
                            break block36;
                        } else {
                            listener.getLogger().println(String.format("Skipping %s. Condition was evaluated to false.", subJob.getName()));
                            phaseCounters.processSkipped();
                            continue;
                        }
                    }
                    if (!jobStatus.isBuildable() && !phaseConfig.isApplyConditionOnlyIfNoSCMChanges()) {
                        listener.getLogger().println(String.format("Skipping %s. No SCM changes found and condition is skipped.", subJob.getName()));
                        phaseCounters.processSkipped();
                        continue;
                    }
                    if (!this.evalCondition(phaseConfig.getCondition(), build, listener)) {
                        listener.getLogger().println(String.format("Skipping %s. Condition was evaluated to false.", subJob.getName()));
                        phaseCounters.processSkipped();
                        continue;
                    }
                    listener.getLogger().println(String.format("Triggering %s. Condition was evaluated to true.", subJob.getName()));
                    conditionExistsAndEvaluatedToTrue = true;
                }
            }
            if (!jobStatus.isBuildable() && !conditionExistsAndEvaluatedToTrue) {
                phaseCounters.processSkipped();
                continue;
            }
            this.reportStart(listener, subJob);
            ArrayList<Action> actions = new ArrayList<Action>();
            if (resume && null != (subBuild = (MultiJobBuild.SubBuild)resumeBuildMap.get(subJob.getUrl()))) {
                AbstractProject prj = (AbstractProject)Jenkins.getInstance().getItem(subBuild.getJobName(), (Item)multiJobBuild.getParent(), AbstractProject.class);
                AbstractBuild childBuild = prj.getBuildByNumber(subBuild.getBuildNumber());
                MultiJobResumeControl childControl = new MultiJobResumeControl((Run<?, ?>)childBuild);
                actions.add(childControl);
            }
            this.prepareActions((AbstractBuild)multiJobBuild, subJob, phaseConfig, listener, actions, index);
            if (jobStatus == StatusJob.IS_DISABLED_AT_PHASECONFIG) {
                phaseCounters.processSkipped();
                continue;
            }
            boolean shouldTrigger = null == successBuildMap.get(subJob.getUrl());
            subTasks.add(new SubTask(subJob, phaseConfig, actions, multiJobBuild, shouldTrigger));
        }
        if (subTasks.size() < 1) {
            this.injectEnvVars(build, listener, phaseCounters.toMap());
            return true;
        }
        if (null == this.executionType) {
            this.executionType = ExecutionType.PARALLEL;
        }
        int poolSize = this.executionType.isParallel() ? subTasks.size() : 1;
        ExecutorService executor = Executors.newFixedThreadPool(poolSize);
        HashSet<Result> jobResults = new HashSet<Result>();
        ArrayBlockingQueue<SubTask> queue = new ArrayBlockingQueue<SubTask>(subTasks.size());
        for (SubTask subTask : subTasks) {
            MultiJobBuild.SubBuild subBuild = (MultiJobBuild.SubBuild)successBuildMap.get(subTask.subJob.getUrl());
            if (null == subBuild) {
                ExecutorCompletionService completion = new ExecutorCompletionService(executor);
                SubJobWorker worker = new SubJobWorker(thisProject, listener, subTask, queue);
                completion.submit(worker);
                if (this.executionType.isParallel()) continue;
                Future future = completion.take();
                try {
                    future.get();
                    if (!this.checkPhaseTermination(subTask, subTasks, listener)) continue;
                    break;
                }
                catch (ExecutionException e) {
                    listener.getLogger().println("Error while execution subtask " + subTask.subJob.getDisplayName());
                    continue;
                }
            }
            AbstractBuild jobBuild = subTask.subJob.getBuildByNumber(subBuild.getBuildNumber());
            this.updateSubBuild(multiJobBuild, thisProject, jobBuild, subBuild.getResult());
        }
        try {
            executor.shutdown();
            int resultCounter = 0;
            while (!executor.isTerminated()) {
                SubTask subTask = (SubTask)queue.poll(5L, TimeUnit.SECONDS);
                if (subTask != null) {
                    ++resultCounter;
                    if (subTask.result != null) {
                        jobResults.add(subTask.result);
                        phaseCounters.process(subTask.result);
                        this.checkPhaseTermination(subTask, subTasks, listener);
                    }
                }
                if (subTasks.size() > resultCounter) continue;
            }
            executor.shutdownNow();
        }
        catch (InterruptedException exception) {
            void var20_34;
            listener.getLogger().println("Aborting all subjobs.");
            for (SubTask _subTask : subTasks) {
                _subTask.cancelJob();
                phaseCounters.processAborted();
            }
            boolean bl = false;
            while (!executor.isTerminated() && var20_34 < 20) {
                Thread.sleep(1000L);
                ++var20_34;
            }
            throw new InterruptedException();
        }
        this.injectEnvVars(build, listener, phaseCounters.toMap());
        Iterator iterator = jobResults.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (this.continuationCondition.isContinue(result = (Result)iterator.next()));
        return false;
    }

    protected boolean checkPhaseTermination(SubTask subTask, List<SubTask> subTasks, BuildListener listener) {
        try {
            PhaseJobsConfig.KillPhaseOnJobResultCondition killCondition = subTask.phaseConfig.getKillPhaseOnJobResultCondition();
            if (killCondition.equals((Object)PhaseJobsConfig.KillPhaseOnJobResultCondition.NEVER) && subTask.result != Result.ABORTED) {
                return false;
            }
            if (killCondition.isKillPhase(subTask.result) && subTask.result != Result.ABORTED && subTask.phaseConfig.getAbortAllJob()) {
                for (SubTask _subTask : subTasks) {
                    _subTask.cancelJob();
                }
                return true;
            }
        }
        catch (Exception e) {
            listener.getLogger().printf(e.toString(), new Object[0]);
            return false;
        }
        return false;
    }

    private void reportStart(BuildListener listener, AbstractProject subJob) {
        listener.getLogger().printf("Starting build job %s.\n", HyperlinkNote.encodeTo((String)('/' + subJob.getUrl()), (String)subJob.getFullName()));
    }

    private void reportFinish(BuildListener listener, AbstractBuild jobBuild, Result result) {
        listener.getLogger().println("Finished Build : " + HyperlinkNote.encodeTo((String)("/" + jobBuild.getUrl() + "/"), (String)String.valueOf(jobBuild.getDisplayName())) + " of Job : " + HyperlinkNote.encodeTo((String)('/' + jobBuild.getProject().getUrl()), (String)jobBuild.getProject().getFullName()) + " with status : " + HyperlinkNote.encodeTo((String)('/' + jobBuild.getUrl() + "/console"), (String)result.toString()));
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, PhaseJobsConfig phaseConfig) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), phaseConfig.getJobName(), 0, this.phaseName, null, BallColor.NOTBUILT.getImage(), "not built", "", null);
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild<?, ?> jobBuild) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, null, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl(), jobBuild);
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild<?, ?> jobBuild, Result result) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, result, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl(), jobBuild);
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild<?, ?> jobBuild, Result result, boolean retry) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, result, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl(), retry, false, jobBuild);
        multiJobBuild.addSubBuild(subBuild);
    }

    private void abortSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild<?, ?> jobBuild) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, Result.ABORTED, BallColor.ABORTED.getImage(), "", jobBuild.getUrl(), false, true, jobBuild);
        multiJobBuild.addSubBuild(subBuild);
    }

    private synchronized void addBuildEnvironmentVariables(MultiJobBuild thisBuild, AbstractBuild jobBuild, BuildListener listener) {
        String runCount;
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
            EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
            Map previousEnvVars = variableGetter.getEnvVarsPreviousSteps((AbstractBuild)thisBuild, logger);
            variables = new HashMap(previousEnvVars);
        }
        catch (Throwable throwable) {
            listener.getLogger().println("[MultiJob] - [ERROR] - Problems occurs on fetching env vars as a build step: " + throwable.getMessage());
        }
        String jobName = jobBuild.getProject().getName();
        String jobNameSafe = jobName.replaceAll("[^A-Za-z0-9]", "_").toUpperCase();
        String buildNumber = Integer.toString(jobBuild.getNumber());
        String buildResult = jobBuild.getResult().toString();
        String buildName = jobBuild.getDisplayName().toString();
        if (variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe) != null && (runCount = (String)variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe)).equals("1")) {
            String firstBuildNumber = (String)variables.get(jobNameSafe + "_BUILD_NUMBER");
            String firstBuildResult = (String)variables.get(jobNameSafe + "_BUILD_RESULT");
            variables.put(jobNameSafe + "_" + runCount + "_BUILD_NUMBER", firstBuildNumber);
            variables.put(jobNameSafe + "_" + runCount + "_BUILD_RESULT", firstBuildResult);
        }
        variables.put("LAST_TRIGGERED_JOB_NAME", jobName);
        variables.put(jobNameSafe + "_BUILD_NUMBER", buildNumber);
        variables.put(jobNameSafe + "_BUILD_RESULT", buildResult);
        variables.put(jobNameSafe + "_BUILD_NAME", buildName);
        if (variables.get("TRIGGERED_JOB_NAMES") == null) {
            variables.put("TRIGGERED_JOB_NAMES", jobName);
        } else {
            String triggeredJobNames = (String)variables.get("TRIGGERED_JOB_NAMES") + "," + jobName;
            variables.put("TRIGGERED_JOB_NAMES", triggeredJobNames);
        }
        if (variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe) == null) {
            variables.put("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe, "1");
        } else {
            runCount = Integer.toString(Integer.parseInt((String)variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe)) + 1);
            variables.put("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe, runCount);
            variables.put(jobNameSafe + "_" + runCount + "_BUILD_NUMBER", buildNumber);
            variables.put(jobNameSafe + "_" + runCount + "_BUILD_RESULT", buildResult);
        }
        this.injectEnvVars((AbstractBuild<?, ?>)thisBuild, listener, (Map<String, String>)variables);
    }

    private void injectEnvVars(AbstractBuild<?, ?> build, BuildListener listener, Map<String, String> incomingVars) {
        if (build != null && incomingVars != null) {
            EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
            FilePath ws = build.getWorkspace();
            EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(ws);
            EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
            try {
                EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
                Map previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
                HashMap<String, String> variables = new HashMap<String, String>(previousEnvVars);
                Map<String, String> mixtured = CounterHelper.putPhaseAddMultijobAndMergeTheRest(listener, this.phaseName, incomingVars, variables);
                Map resultVariables = envInjectEnvVarsService.getMergedVariables(variables, mixtured);
                build.addAction((Action)new EnvInjectBuilderContributionAction(resultVariables));
                envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, resultVariables);
            }
            catch (Throwable throwable) {
                listener.getLogger().println("[MultiJob] - [ERROR] - Problems occurs on injecting env vars as a build step: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
    }

    private void prepareActions(AbstractBuild build, AbstractProject project, PhaseJobsConfig projectConfig, BuildListener listener, List<Action> actions, int index) throws IOException, InterruptedException {
        List<Action> parametersActions = null;
        parametersActions = projectConfig.getActions(build, (TaskListener)listener, project, projectConfig.isCurrParams());
        actions.addAll(parametersActions);
        actions.add(new MultiJobAction(build, index));
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public List<PhaseJobsConfig> getPhaseJobs() {
        return this.phaseJobs;
    }

    public void setPhaseJobs(List<PhaseJobsConfig> phaseJobs) {
        this.phaseJobs = phaseJobs;
    }

    public boolean phaseNameExist(String phaseName) {
        for (PhaseJobsConfig phaseJob : this.phaseJobs) {
            if (!phaseJob.getDisplayName().equals(phaseName)) continue;
            return true;
        }
        return false;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        Jenkins jenkins = Jenkins.getInstance();
        List<PhaseJobsConfig> phaseJobsConfigs = this.getPhaseJobs();
        if (phaseJobsConfigs == null) {
            return;
        }
        for (PhaseJobsConfig project : phaseJobsConfigs) {
            Item topLevelItem = jenkins.getItem(project.getJobName(), owner.getParent(), AbstractProject.class);
            if (!(topLevelItem instanceof AbstractProject)) continue;
            DependencyGraph.Dependency dependency = new DependencyGraph.Dependency(owner, (AbstractProject)topLevelItem){

                public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                    return false;
                }
            };
            graph.addDependency(dependency);
        }
    }

    public boolean onJobRenamed(String oldName, String newName) {
        boolean changed = false;
        Iterator<PhaseJobsConfig> i = this.phaseJobs.iterator();
        while (i.hasNext()) {
            PhaseJobsConfig phaseJobs = i.next();
            String jobName = phaseJobs.getJobName();
            if (!jobName.trim().equals(oldName)) continue;
            if (newName != null) {
                phaseJobs.setJobName(newName);
                changed = true;
                continue;
            }
            i.remove();
            changed = true;
        }
        return changed;
    }

    public boolean onJobDeleted(String oldName) {
        return this.onJobRenamed(oldName, null);
    }

    public ContinuationCondition getContinuationCondition() {
        return this.continuationCondition;
    }

    public void setContinuationCondition(ContinuationCondition continuationCondition) {
        this.continuationCondition = continuationCondition;
    }

    public void setExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public boolean prebuild(Build build, BuildListener listener) {
        boolean resume = false;
        MultiJobResumeControl control = (MultiJobResumeControl)build.getAction(MultiJobResumeControl.class);
        if (null != control) {
            MultiJobBuild prevBuild = (MultiJobBuild)control.getRun();
            for (MultiJobBuild.SubBuild subBuild : prevBuild.getSubBuilds()) {
                AbstractProject childProject;
                AbstractBuild childBuild;
                Item item = Jenkins.getInstance().getItem(subBuild.getJobName(), (Item)prevBuild.getParent(), AbstractProject.class);
                if (!(item instanceof AbstractProject) || null == (childBuild = (childProject = (AbstractProject)item).getBuildByNumber(subBuild.getBuildNumber())) || !childBuild.getResult().equals(Result.FAILURE)) continue;
                resume = true;
            }
            if (resume) {
                EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
                EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
                try {
                    Map previousEnvVars = variableGetter.getEnvVarsPreviousSteps((AbstractBuild)prevBuild, logger);
                    HashMap<String, String> persistentEnvVars = new HashMap<String, String>();
                    for (String key : previousEnvVars.keySet()) {
                        if (!key.startsWith(PERSISTENT_VARS_PREFIX)) continue;
                        persistentEnvVars.put(key, (String)previousEnvVars.get(key));
                    }
                    persistentEnvVars.put("RESUMED_BUILD", "true");
                    this.injectEnvVars((AbstractBuild<?, ?>)build, listener, (Map<String, String>)persistentEnvVars);
                }
                catch (Throwable throwable) {
                    listener.getLogger().println("[MultiJob] - [ERROR] - Problems occurs on injecting env vars in prebuild: " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
        return true;
    }

    public static enum ExecutionType {
        PARALLEL("Running phase jobs in parallel"){

            @Override
            public boolean isParallel() {
                return true;
            }
        }
        ,
        SEQUENTIALLY("Running phase jobs sequentially"){

            @Override
            public boolean isParallel() {
                return false;
            }
        };

        private final String label;

        private ExecutionType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public abstract boolean isParallel();
    }

    public static enum ContinuationCondition {
        ALWAYS("Always"){

            @Override
            public boolean isContinue(Result result) {
                return true;
            }
        }
        ,
        SUCCESSFUL("Successful"){

            @Override
            public boolean isContinue(Result result) {
                return result.equals(Result.SUCCESS);
            }
        }
        ,
        COMPLETED("Completed"){

            @Override
            public boolean isContinue(Result result) {
                return result.isCompleteBuild();
            }
        }
        ,
        UNSTABLE("Stable or Unstable but not Failed"){

            @Override
            public boolean isContinue(Result result) {
                return result.isBetterOrEqualTo(Result.UNSTABLE);
            }
        }
        ,
        FAILURE("Failed"){

            @Override
            public boolean isContinue(Result result) {
                return result.isWorseOrEqualTo(Result.FAILURE);
            }
        };

        private final String label;

        public abstract boolean isContinue(Result var1);

        private ContinuationCondition(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType.equals(MultiJobProject.class);
        }

        public String getDisplayName() {
            return "MultiJob Phase";
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(MultiJobBuilder.class, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.save();
            return true;
        }
    }

    private static final class PhaseSubJob {
        AbstractProject job;

        PhaseSubJob(AbstractProject job) {
            this.job = job;
        }
    }

    private class MultiJobAction
    implements Action,
    Queue.QueueAction {
        public int buildNumber;
        public int index;
        @Deprecated
        private transient AbstractBuild build;

        public MultiJobAction(AbstractBuild build, int index) {
            this.buildNumber = build.getNumber();
            this.index = index;
        }

        public boolean shouldSchedule(List<Action> actions) {
            boolean matches = true;
            for (MultiJobAction action : Util.filter(actions, MultiJobAction.class)) {
                if (action.index != this.index) {
                    matches = false;
                }
                if (action.buildNumber == this.buildNumber) continue;
                matches = false;
            }
            return !matches;
        }

        protected Object readResolve() {
            if (this.build != null) {
                this.buildNumber = this.build.getNumber();
            }
            return this;
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return "this shouldn't be displayed";
        }

        public String getUrlName() {
            return null;
        }
    }

    public final class SubJobWorker
    implements Callable {
        private final MultiJobProject multiJobProject;
        private final BuildListener listener;
        private SubTask subTask;
        private BlockingQueue<SubTask> queue;
        private List<Pattern> compiledPatterns;

        public SubJobWorker(MultiJobProject multiJobProject, BuildListener listener, SubTask subTask, BlockingQueue<SubTask> queue) {
            this.multiJobProject = multiJobProject;
            this.listener = listener;
            this.subTask = subTask;
            this.queue = queue;
        }

        public Object call() {
            Result result = null;
            AbstractBuild jobBuild = null;
            try {
                int maxRetries = this.subTask.phaseConfig.getMaxRetries();
                if (!this.subTask.phaseConfig.getEnableRetryStrategy()) {
                    maxRetries = 0;
                }
                int retry = 0;
                boolean finish = false;
                while (retry <= maxRetries && !finish) {
                    ++retry;
                    if (this.subTask.isShouldTrigger()) {
                        this.subTask.generateFuture();
                    }
                    QueueTaskFuture future = (QueueTaskFuture)this.subTask.future;
                    while (true) {
                        if (this.subTask.isCancelled() && jobBuild != null) {
                            Executor exect = jobBuild.getExecutor();
                            if (exect != null) {
                                exect.interrupt(Result.ABORTED);
                            }
                            MultiJobBuilder.this.reportFinish(this.listener, jobBuild, Result.ABORTED);
                            MultiJobBuilder.this.abortSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild);
                            finish = true;
                            break;
                        }
                        try {
                            jobBuild = (AbstractBuild)future.getStartCondition().get(5L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            if (e instanceof TimeoutException) continue;
                            throw e;
                        }
                        MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild);
                        if (future.isDone()) break;
                        Thread.sleep(2500L);
                    }
                    if (jobBuild == null || finish) continue;
                    result = jobBuild.getResult();
                    MultiJobBuilder.this.reportFinish(this.listener, jobBuild, result);
                    if (result.isWorseOrEqualTo(Result.UNSTABLE) && result.isCompleteBuild() && this.subTask.phaseConfig.getEnableRetryStrategy()) {
                        if (this.isKnownRandomFailure(jobBuild)) {
                            if (retry <= maxRetries) {
                                this.listener.getLogger().println("Known failure detected, retrying this build. Try " + retry + " of " + maxRetries + ".");
                                MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result, true);
                                this.subTask.generateFuture();
                            } else {
                                this.listener.getLogger().println("Known failure detected, max retries (" + maxRetries + ") exceeded.");
                                MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result);
                            }
                        } else {
                            this.listener.getLogger().println("Failed the build, the failure doesn't match the rules.");
                            MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result);
                            finish = true;
                        }
                    } else {
                        MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result);
                        finish = true;
                    }
                    ChangeLogSet changeLogSet = jobBuild.getChangeSet();
                    this.subTask.multiJobBuild.addChangeLogSet((ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet);
                    MultiJobBuilder.this.addBuildEnvironmentVariables(this.subTask.multiJobBuild, jobBuild, this.listener);
                    this.subTask.result = result;
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    if (jobBuild != null) {
                        MultiJobBuilder.this.reportFinish(this.listener, jobBuild, Result.ABORTED);
                        MultiJobBuilder.this.abortSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild);
                        this.subTask.result = Result.ABORTED;
                    }
                }
                this.listener.getLogger().println(e.toString());
            }
            if (jobBuild == null) {
                MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, this.subTask.phaseConfig);
            }
            this.queue.add(this.subTask);
            return Boolean.TRUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Pattern> getCompiledPattern() throws FileNotFoundException, InterruptedException {
            if (this.compiledPatterns == null) {
                this.compiledPatterns = new ArrayList<Pattern>();
                try {
                    this.listener.getLogger().println("Scanning failed job console output using parsing rule file " + this.subTask.phaseConfig.getParsingRulesPath() + ".");
                    File rulesFile = new File(this.subTask.phaseConfig.getParsingRulesPath());
                    FileInputStream fis = new FileInputStream(rulesFile.getAbsoluteFile());
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                    try (BufferedReader reader = new BufferedReader(isr);){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.compiledPatterns.add(Pattern.compile(line));
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        throw new InterruptedException();
                    }
                    if (e instanceof FileNotFoundException) {
                        throw new FileNotFoundException();
                    }
                    this.listener.getLogger().println(e.toString());
                    e.printStackTrace();
                }
            }
            return this.compiledPatterns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isKnownRandomFailure(AbstractBuild build) throws InterruptedException {
            boolean failure = false;
            try {
                List<Pattern> patterns = this.getCompiledPattern();
                File logFile = build.getLogFile();
                FileInputStream fis = new FileInputStream(logFile);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                try (BufferedReader reader = new BufferedReader(isr);){
                    int numberOfThreads = 10;
                    if (numberOfThreads < 0) {
                        numberOfThreads = 1;
                    }
                    ExecutorService executorAnalyser = Executors.newFixedThreadPool(numberOfThreads);
                    ArrayBlockingQueue<LineQueue> finishQueue = new ArrayBlockingQueue<LineQueue>(numberOfThreads);
                    for (int i = 0; i < numberOfThreads; ++i) {
                        LineAnalyser worker = new LineAnalyser(reader, patterns, finishQueue);
                        executorAnalyser.execute(worker);
                    }
                    executorAnalyser.shutdown();
                    int resultCounter = 0;
                    while (!executorAnalyser.isTerminated()) {
                        ++resultCounter;
                        LineQueue lineQueue = (LineQueue)finishQueue.take();
                        if (lineQueue.hasError()) {
                            failure = true;
                            break;
                        }
                        if (numberOfThreads != resultCounter) continue;
                        break;
                    }
                    executorAnalyser.shutdownNow();
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    throw new InterruptedException();
                }
                if (e instanceof FileNotFoundException) {
                    this.listener.getLogger().println("Parser rules file not found.");
                    failure = false;
                }
                this.listener.getLogger().println(e.toString());
                e.printStackTrace();
            }
            return failure;
        }

        private final class LineAnalyser
        extends Thread {
            private final BufferedReader reader;
            private final List<Pattern> patterns;
            private BlockingQueue<LineQueue> finishQueue;

            public LineAnalyser(BufferedReader reader, List<Pattern> patterns, BlockingQueue<LineQueue> finishQueue) {
                this.reader = reader;
                this.patterns = patterns;
                this.finishQueue = finishQueue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean errorFound = false;
                try {
                    block5: while (this.reader.ready() && !errorFound) {
                        String line = this.reader.readLine();
                        if (line == null) continue;
                        for (Pattern pattern : this.patterns) {
                            if (!pattern.matcher(line).find()) continue;
                            errorFound = true;
                            continue block5;
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                    } else {
                        SubJobWorker.this.listener.getLogger().println(e.toString());
                        e.printStackTrace();
                    }
                }
                finally {
                    this.finishQueue.add(new LineQueue(errorFound));
                }
            }
        }
    }
}

