/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.Messages;
import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import hudson.EnvVars;
import hudson.Extension;
import hudson.matrix.MatrixRun;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class MultiJobBuildSelector
extends BuildSelector {
    private static final Logger LOGGER = Logger.getLogger(MultiJobBuildSelector.class.getName());
    @Extension(optional=true, ordinal=20.0)
    public static final Descriptor<BuildSelector> DESCRIPTOR = new SimpleBuildSelectorDescriptor(MultiJobBuildSelector.class, Messages._MultiJobBuildSelector_DisplayName());

    @DataBoundConstructor
    public MultiJobBuildSelector() {
    }

    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        MultiJobBuild multiJobBuild = null;
        if (parent instanceof MultiJobBuild) {
            multiJobBuild = (MultiJobBuild)parent;
        } else {
            for (Cause cause : parent instanceof MatrixRun ? ((MatrixRun)parent).getParentBuild().getCauses() : parent.getCauses()) {
                Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
                Job upstreamJob = (Job)Jenkins.getInstance().getItemByFullName(upstreamCause.getUpstreamProject(), Job.class);
                Run upstreamRun = upstreamJob.getBuildByNumber(upstreamCause.getUpstreamBuild());
                if (upstreamRun == null || !(upstreamRun instanceof MultiJobBuild)) continue;
                multiJobBuild = (MultiJobBuild)upstreamRun;
            }
        }
        if (multiJobBuild == null) {
            LOGGER.warning(String.format("'%s' is not found to be part of a MultiJob Project.", parent.getFullDisplayName()));
            return null;
        }
        for (MultiJobBuild.SubBuild subBuild : multiJobBuild.getSubBuilds()) {
            Run run;
            if (!subBuild.getJobName().equals(job.getDisplayName()) || !filter.isSelectable(run = job.getBuildByNumber(subBuild.getBuildNumber()), env)) continue;
            return run;
        }
        return null;
    }

    public boolean isSelectable(Run<?, ?> run, EnvVars env) {
        return true;
    }
}

