/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.jenkinsci.plugins.htmlresource;

import com.cwctravel.jenkinsci.plugins.htmlresource.HTMLResourceManagement;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResource;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResourceConfiguration;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResourceEntry;
import hudson.model.ManagementLink;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerResponse;

public class HTMLResourceUtil {
    private static final Pattern RESOURCE_ENTRY_PATTERN = Pattern.compile("META-INF/resources/webjars/(.*\\.(css|js))");
    private static final Logger LOGGER = Logger.getLogger(HTMLResourceUtil.class.getName());

    public static void syncDirWithCfg(File scriptDirectory, HTMLResourceConfiguration cfg) throws IOException {
        List<File> availablePhysicalScripts = HTMLResourceUtil.getAvailableScripts(scriptDirectory);
        for (File file : availablePhysicalScripts) {
            if (cfg.getHTMLResourceById(file.getName()) != null) continue;
            cfg.addOrReplace(new HTMLResource(file.getName(), file.getName(), -1, null));
        }
        HashSet<HTMLResource> unavailableScripts = new HashSet<HTMLResource>();
        for (HTMLResource s : cfg.getHTMLResources()) {
            if (new File(scriptDirectory, s.getResourcePath()).exists()) {
                s.setAvailable(true);
                continue;
            }
            unavailableScripts.add(new HTMLResource(s.getId(), s.getName(), s.getIndex(), s.getInitializationScript()));
            LOGGER.info("for repo '" + scriptDirectory.getAbsolutePath() + "' " + s + " is not available!");
        }
        for (HTMLResource script : unavailableScripts) {
            cfg.addOrReplace(script);
        }
        cfg.normalizeIndices();
    }

    private static List<File> getAvailableScripts(File scriptDirectory) throws IOException {
        LOGGER.log(Level.FINE, "Listing files of {0}", scriptDirectory.getAbsoluteFile());
        File[] scriptFiles = scriptDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        List<File> fileList = scriptFiles == null ? new ArrayList<File>() : Arrays.asList(scriptFiles);
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HTMLResourceEntry> computeResourceEntries(File scriptDirectory, HTMLResource resource) throws IOException {
        ArrayList<HTMLResourceEntry> result = new ArrayList<HTMLResourceEntry>();
        File webJARFile = new File(scriptDirectory, resource.getResourcePath());
        HashMap<String, HTMLResourceEntry> allResourceEntriesMap = new HashMap<String, HTMLResourceEntry>();
        try (JarFile jarFile = new JarFile(webJARFile);){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                Matcher resourceEntryMatcher;
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory() || !(resourceEntryMatcher = RESOURCE_ENTRY_PATTERN.matcher(jarEntry.getName())).matches()) continue;
                String resourceEntryPath = resourceEntryMatcher.group(1);
                HTMLResourceEntry resourceEntry = new HTMLResourceEntry(resourceEntryPath);
                allResourceEntriesMap.put(resourceEntryPath, resourceEntry);
            }
        }
        List<HTMLResourceEntry> selectedResourceEntries = resource.getResourceEntries();
        if (selectedResourceEntries != null) {
            for (HTMLResourceEntry selectedResourceEntry : selectedResourceEntries) {
                HTMLResourceEntry resourceEntry = (HTMLResourceEntry)allResourceEntriesMap.get(selectedResourceEntry.getPath());
                if (resourceEntry == null) continue;
                resourceEntry.setSelected(true);
            }
        }
        result.addAll(allResourceEntriesMap.values());
        Collections.sort(result);
        return result;
    }

    public static boolean hasResourceEntry(HTMLResource resource, String resourceEntryPath) {
        boolean result = false;
        if (resource != null) {
            List<HTMLResourceEntry> resourceEntries = resource.getResourceEntries();
            for (HTMLResourceEntry resourceEntry : resourceEntries) {
                if (!resourceEntry.getPath().equals(resourceEntryPath)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResourceEntry(HTMLResource resource, File webJARDirectory, String resourceEntryPath, StaplerResponse response) throws IOException {
        block7: {
            File file;
            if (resource != null && (file = new File(webJARDirectory, resource.getId())).exists()) {
                try (JarFile jarFile = new JarFile(file);){
                    JarEntry jarEntry = jarFile.getJarEntry("META-INF/resources/webjars/" + resourceEntryPath);
                    if (jarEntry == null) break block7;
                    try (InputStream iS = jarFile.getInputStream(jarEntry);){
                        IOUtils.copy((InputStream)iS, (OutputStream)response.getOutputStream());
                        response.flushBuffer();
                    }
                }
            }
        }
    }

    public static List<String> getResourcePathsMatchingExtension(HTMLResourceConfiguration config, String extension) {
        ArrayList<String> result = new ArrayList<String>();
        if (config != null) {
            List<HTMLResource> resources = config.getHTMLResources();
            for (HTMLResource resource : resources) {
                List<HTMLResourceEntry> resourceEntries = resource.getResourceEntries();
                if (resourceEntries == null) continue;
                for (HTMLResourceEntry resourceEntry : resourceEntries) {
                    if (!resourceEntry.getPath().endsWith("." + extension)) continue;
                    result.add("webjars/" + resource.getId() + "/" + resourceEntry.getPath());
                }
            }
        }
        return result;
    }

    public static List<String> getInitializationScripts(HTMLResourceConfiguration config) {
        ArrayList<String> result = new ArrayList<String>();
        if (config != null) {
            List<HTMLResource> resources = config.getHTMLResources();
            for (HTMLResource resource : resources) {
                String initializationScript = resource.getInitializationScript();
                if (initializationScript == null) continue;
                result.add(initializationScript);
            }
        }
        return result;
    }

    public static HTMLResourceManagement getHTMLResourceManagement() {
        HTMLResourceManagement result = null;
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance != null) {
            List managementLinks = jenkinsInstance.getManagementLinks();
            for (ManagementLink managementLink : managementLinks) {
                if (!(managementLink instanceof HTMLResourceManagement)) continue;
                result = (HTMLResourceManagement)managementLink;
                break;
            }
        }
        return result;
    }
}

