/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.jenkinsci.plugins.htmlresource;

import com.cwctravel.jenkinsci.plugins.htmlresource.HTMLResourcePluginImpl;
import com.cwctravel.jenkinsci.plugins.htmlresource.HTMLResourceUtil;
import com.cwctravel.jenkinsci.plugins.htmlresource.Messages;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResource;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResourceConfiguration;
import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResourceEntry;
import hudson.Extension;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class HTMLResourceManagement
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(HTMLResourceManagement.class.getName());

    public String getUrlName() {
        return "htmlresource";
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public HTMLResourceManagement getHTMLResourceManager() {
        return this;
    }

    public HTMLResourceConfiguration getConfiguration() {
        return HTMLResourceConfiguration.getConfiguration();
    }

    public String getPluginResourcePath() {
        String result = null;
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance != null) {
            PluginWrapper wrapper = jenkinsInstance.getPluginManager().getPlugin(HTMLResourcePluginImpl.class);
            result = jenkinsInstance.getRootUrl() + "plugin/" + wrapper.getShortName() + "/";
        }
        return result;
    }

    public void doEditResourceEntries(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        HTMLResource resource = this.getConfiguration().getHTMLResourceById(id);
        req.setAttribute("resource", (Object)resource);
        req.setAttribute("resourceEntries", HTMLResourceUtil.computeResourceEntries(HTMLResourceManagement.getWebJARDirectory(), resource));
        req.getView((Object)this, "editResourceEntries.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public HttpResponse doRemoveHTMLResource(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        File oldScript = new File(HTMLResourceManagement.getWebJARDirectory(), id);
        if (oldScript.delete()) {
            HTMLResourceConfiguration cfg = this.getConfiguration();
            cfg.removeHTMLResource(id);
            cfg.save();
        }
        return new HttpRedirect("index");
    }

    public HttpResponse doMoveResourceUp(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        HTMLResourceConfiguration cfg = this.getConfiguration();
        HTMLResource resource = cfg.getHTMLResourceById(id);
        cfg.moveHTMLResourceUp(resource);
        cfg.save();
        return new HttpRedirect("index");
    }

    public HttpResponse doMoveResourceDown(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException {
        this.checkPermission(Hudson.ADMINISTER);
        HTMLResourceConfiguration cfg = this.getConfiguration();
        HTMLResource resource = cfg.getHTMLResourceById(id);
        cfg.moveHTMLResourceDown(resource);
        cfg.save();
        return new HttpRedirect("index");
    }

    public HttpResponse doUploadHTMLResource(StaplerRequest req) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        try {
            FileItem fileItem = req.getFileItem("file");
            String fileName = Util.getFileName((String)fileItem.getName());
            if (StringUtils.isEmpty((String)fileName)) {
                return new HttpRedirect(".");
            }
            this.saveHTMLResource(fileItem, fileName);
            return new HttpRedirect("index");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public HttpResponse doUpdateResourceEntries(StaplerRequest req, @QueryParameter(value="id") String id) throws IOException, ServletException {
        HTMLResource resource;
        this.checkPermission(Hudson.ADMINISTER);
        JSONObject jsonData = req.getSubmittedForm();
        String initializationScript = jsonData.optString("initializationScript");
        JSONArray entries = jsonData.optJSONArray("entries");
        if (entries == null && jsonData.optBoolean("entries")) {
            entries = new JSONArray();
            entries.add((Object)true);
        }
        if (entries != null && (resource = this.getConfiguration().getHTMLResourceById(id)) != null) {
            ArrayList<HTMLResourceEntry> selectedResourcEntries = new ArrayList<HTMLResourceEntry>();
            List<HTMLResourceEntry> resourceEntries = HTMLResourceUtil.computeResourceEntries(HTMLResourceManagement.getWebJARDirectory(), resource);
            if (resourceEntries != null && resourceEntries.size() <= entries.size()) {
                for (int i = 0; i < entries.size(); ++i) {
                    if (!entries.getBoolean(i)) continue;
                    HTMLResourceEntry selectedResourceEntry = resourceEntries.get(i);
                    selectedResourceEntry.setSelected(true);
                    selectedResourcEntries.add(selectedResourceEntry);
                }
            }
            resource.setResourceEntries(selectedResourcEntries);
            resource.setInitializationScript(initializationScript);
            HTMLResourceConfiguration config = this.getConfiguration();
            config.addOrReplace(resource);
            config.save();
        }
        return new HttpRedirect("index");
    }

    private String determineContentType(StaplerRequest req) {
        int lastIndexOfDot;
        String contentType = null;
        String resourcePath = req.getPathInfo();
        String extension = resourcePath.substring(lastIndexOfDot = resourcePath.lastIndexOf(46));
        if (".css".equals(extension)) {
            contentType = "text/css";
        } else if (".js".equals(extension)) {
            contentType = "application/x-javascript";
        } else if (".png".equals(extension)) {
            contentType = "image/png";
        } else if (".gif".equals(extension)) {
            contentType = "image/gif";
        } else {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            contentType = mimeTypesMap.getContentType(resourcePath);
        }
        return contentType;
    }

    public void doWebjars(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        String contentType = this.determineContentType(req);
        this.writeHTMLResource(req, resp, contentType);
    }

    private void writeHTMLResource(StaplerRequest req, StaplerResponse resp, String contentType) throws IOException {
        int indexOf4thSlash;
        String resourcePath = req.getPathInfo();
        int indexOfSlash = resourcePath.indexOf(47);
        indexOfSlash = indexOfSlash >= 0 ? resourcePath.indexOf(47, indexOfSlash + 1) : -1;
        int n = indexOfSlash = indexOfSlash >= 0 ? resourcePath.indexOf(47, indexOfSlash + 1) : -1;
        if (indexOfSlash > 0 && (indexOf4thSlash = resourcePath.indexOf(47, indexOfSlash + 1)) > 0) {
            String resourceId = resourcePath.substring(indexOfSlash + 1, indexOf4thSlash);
            String resourceEntryPath = resourcePath.substring(indexOf4thSlash + 1);
            HTMLResource resource = this.getConfiguration().getHTMLResourceById(resourceId);
            resp.setContentType(contentType);
            HTMLResourceUtil.writeResourceEntry(resource, HTMLResourceManagement.getWebJARDirectory(), resourceEntryPath, resp);
        }
    }

    void saveHTMLResource(FileItem fileItem, String fileName) throws Exception, IOException {
        File rootDir = HTMLResourceManagement.getWebJARDirectory();
        File f = new File(rootDir, fileName);
        fileItem.write(f);
        if (this.validateWebJAR(f)) {
            HTMLResource resource = new HTMLResource(fileName, fileName, -1, null);
            HTMLResourceConfiguration config = this.getConfiguration();
            config.addOrReplace(resource);
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateWebJAR(File file) throws IOException {
        boolean result = false;
        if (file.getName().endsWith(".jar")) {
            try (JarFile jarFile = new JarFile(file);){
                result = jarFile.size() > 0;
            }
        }
        return result;
    }

    public static File getWebJARDirectory() {
        return new File(HTMLResourceManagement.getHTMLResourceHomeDirectory(), "webjars");
    }

    public static File getHTMLResourceHomeDirectory() {
        File result = null;
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance != null) {
            result = new File(jenkinsInstance.getRootDir(), "htmlresource");
        }
        return result;
    }

    private void checkPermission(Permission permission) {
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance != null) {
            jenkinsInstance.checkPermission(permission);
        }
    }

    public String getIconFileName() {
        return "notepad.gif";
    }
}

