/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher;

import htmlpublisher.HtmlPublisherTarget;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class HtmlPublisher
extends Recorder {
    private final ArrayList<HtmlPublisherTarget> reportTargets;

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    public HtmlPublisher(List<HtmlPublisherTarget> reportTargets) {
        this.reportTargets = reportTargets != null ? new ArrayList<HtmlPublisherTarget>(reportTargets) : new ArrayList();
    }

    public ArrayList<HtmlPublisherTarget> getReportTargets() {
        return this.reportTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String writeFile(ArrayList<String> lines, File path) throws IOException, NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), Charset.defaultCharset()));){
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i) + "\n";
                bw.write(line);
                sha1.update(line.getBytes("UTF-8"));
            }
        }
        return Util.toHexString((byte[])sha1.digest());
    }

    public ArrayList<String> readFile(String filePath) throws FileNotFoundException, IOException {
        return HtmlPublisher.readFile(filePath, ((Object)((Object)this)).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> readFile(String filePath, Class<?> publisherClass) throws FileNotFoundException, IOException {
        ArrayList<String> aList = new ArrayList<String>();
        try {
            InputStream is = publisherClass.getResourceAsStream(filePath);
            try {
                InputStreamReader r = new InputStreamReader(is, Charset.defaultCharset());
                try {
                    BufferedReader br = new BufferedReader(r);
                    try {
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            aList.add(line);
                        }
                        br.close();
                        ((Reader)r).close();
                        is.close();
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        ((Reader)r).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return aList;
    }

    protected static String resolveParametersInString(Run<?, ?> build, TaskListener listener, String input) {
        if (build instanceof AbstractBuild) {
            try {
                return build.getEnvironment(listener).expand(input);
            }
            catch (Exception e) {
                listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            }
        } else {
            if (input.matches("\\$\\{.*\\}")) {
                listener.getLogger().println("***************");
                listener.getLogger().println("*** WARNING ***");
                listener.getLogger().println("***************");
                listener.getLogger().print("You appear to be relying on the HTML Publisher plugin to resolve variables in a Pipeline build. ");
                listener.getLogger().print("This is not considered best practice and will be removed in a future release. ");
                listener.getLogger().println("Please use a Groovy mechanism to evaluate the string.");
            }
            try {
                return build.getEnvironment(listener).expand(input);
            }
            catch (Exception e) {
                listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            }
        }
        return input;
    }

    protected static String resolveParametersInString(EnvVars envVars, TaskListener listener, String input) {
        try {
            return envVars.expand(input);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            return input;
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        return HtmlPublisher.publishReports(build, build.getWorkspace(), launcher, (TaskListener)listener, this.reportTargets, ((Object)((Object)this)).getClass());
    }

    public static boolean publishReports(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, List<HtmlPublisherTarget> reportTargets, Class<?> publisherClass) throws InterruptedException {
        ArrayList<String> footerLines;
        ArrayList<String> headerLines;
        listener.getLogger().println("[htmlpublisher] Archiving HTML reports...");
        try {
            headerLines = HtmlPublisher.readFile("/htmlpublisher/HtmlPublisher/header.html", publisherClass);
            footerLines = HtmlPublisher.readFile("/htmlpublisher/HtmlPublisher/footer.html", publisherClass);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
        for (int i = 0; i < reportTargets.size(); ++i) {
            ArrayList<String> reportLines = new ArrayList<String>(headerLines);
            HtmlPublisherTarget reportTarget = reportTargets.get(i);
            boolean keepAll = reportTarget.getKeepAll();
            boolean allowMissing = reportTarget.getAllowMissing();
            FilePath archiveDir = workspace.child(HtmlPublisher.resolveParametersInString(build, listener, reportTarget.getReportDir()));
            FilePath targetDir = reportTarget.getArchiveTarget(build);
            String levelString = keepAll ? "BUILD" : "PROJECT";
            listener.getLogger().println("[htmlpublisher] Archiving at " + levelString + " level " + archiveDir + " to " + targetDir);
            String[] csvReports = HtmlPublisher.resolveParametersInString(build, listener, reportTarget.getReportFiles()).split(",");
            String[] titles = null;
            if (reportTarget.getReportTitles() != null && reportTarget.getReportTitles().trim().length() > 0) {
                titles = reportTarget.getReportTitles().trim().split("\\s*,\\s*");
                for (int j = 0; j < titles.length; ++j) {
                    titles[j] = HtmlPublisher.resolveParametersInString(build, listener, titles[j]);
                }
            }
            ArrayList<String> reports = new ArrayList<String>();
            for (int j = 0; j < csvReports.length; ++j) {
                String report = csvReports[j];
                if ((report = report.trim()).equals("")) continue;
                reports.add(report);
                String tabNo = "tab" + (j + 1);
                int end = report.lastIndexOf(46);
                String reportFile = end > 0 ? report.substring(0, end) : report;
                String tabItem = "<li id=\"" + tabNo + "\" class=\"unselected\" onclick=\"updateBody('" + tabNo + "');\" value=\"" + report + "\">" + HtmlPublisher.getTitle(reportFile, titles, j) + "</li>";
                reportLines.add(tabItem);
            }
            String hudsonUrl = Jenkins.getActiveInstance().getRootUrl();
            Job job = build.getParent();
            reportLines.add("<script type=\"text/javascript\">document.getElementById(\"hudson_link\").innerHTML=\"Back to " + job.getName() + "\";</script>");
            if (hudsonUrl == null) {
                reportLines.add("<script type=\"text/javascript\">document.getElementById(\"hudson_link\").onclick = function() { history.go(-1); return false; };</script>");
            } else {
                String jobUrl = hudsonUrl + job.getUrl();
                reportLines.add("<script type=\"text/javascript\">document.getElementById(\"hudson_link\").href=\"" + jobUrl + "\";</script>");
            }
            reportLines.add("<script type=\"text/javascript\">document.getElementById(\"zip_link\").href=\"*zip*/" + reportTarget.getSanitizedName() + ".zip\";</script>");
            try {
                if (!archiveDir.exists() && !allowMissing) {
                    listener.error("Specified HTML directory '" + archiveDir + "' does not exist.");
                    build.setResult(Result.FAILURE);
                    return true;
                }
                if (!keepAll) {
                    targetDir.deleteRecursive();
                }
                if (archiveDir.copyRecursiveTo(reportTarget.getIncludes(), targetDir) == 0 && !allowMissing) {
                    listener.error("Directory '" + archiveDir + "' exists but failed copying to '" + targetDir + "'.");
                    Result buildResult = build.getResult();
                    if (buildResult != null && buildResult.isBetterOrEqualTo(Result.UNSTABLE)) {
                        listener.error("This is especially strange since your build otherwise succeeded.");
                    }
                    build.setResult(Result.FAILURE);
                    return true;
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("HTML Publisher failure"));
                build.setResult(Result.FAILURE);
                return true;
            }
            reportLines.addAll(footerLines);
            try {
                if (!archiveDir.exists()) continue;
                String checksum = HtmlPublisher.writeFile(reportLines, new File(targetDir.getRemote(), reportTarget.getWrapperName()));
                reportTarget.handleAction(build, checksum);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static String getTitle(String report, String[] titles, int j) {
        if (titles != null && titles.length > j) {
            return titles[j];
        }
        return report;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        if (this.reportTargets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (HtmlPublisherTarget target : this.reportTargets) {
            actions.add(target.getProjectAction((AbstractItem)project));
            if (!(project instanceof MatrixProject) || ((MatrixProject)project).getActiveConfigurations() == null) continue;
            for (MatrixConfiguration mc : ((MatrixProject)project).getActiveConfigurations()) {
                try {
                    mc.onLoad((ItemGroup)mc.getParent(), mc.getName());
                }
                catch (IOException iOException) {}
            }
        }
        return actions;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish HTML reports";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateRelativeDirectory(value) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

