/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin.results;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvClassResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvJUnitResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvProfileResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvTestCaseResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvTestSuiteResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.XmlTestCaseElementCreator;
import org.jenkinsci.remoting.RoleChecker;

public class NvResultsMerger {
    public static void mergeResults(AbstractBuild<?, ?> build, String reportFilesPattern, NvJUnitResult result) throws IOException, InterruptedException {
        FilePath[] files;
        FilePath workspace = build.getWorkspace();
        for (FilePath file : files = workspace.list(reportFilesPattern)) {
            file.act((FilePath.FileCallable)new MergeFileCallable(result));
        }
    }

    public static class MergeFileCallable
    implements FilePath.FileCallable<Void> {
        private static final long serialVersionUID = 1498088030227367799L;
        private NvJUnitResult result;

        public MergeFileCallable(NvJUnitResult result) {
            this.result = result;
        }

        public Void invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
            block5: {
                Document document;
                SAXBuilder saxBuilder = new SAXBuilder();
                try {
                    document = saxBuilder.build(file);
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                    return null;
                }
                Element rootElement = document.getRootElement();
                for (Element suiteElement : this.getSuiteElements(rootElement)) {
                    this.updateSuiteElement(suiteElement);
                    this.replaceTestCaseElements(suiteElement);
                }
                document.setContent((Content)rootElement);
                FileWriter writer = null;
                try {
                    writer = new FileWriter(file);
                    XMLOutputter xmlOutputter = new XMLOutputter();
                    xmlOutputter.setFormat(Format.getPrettyFormat());
                    xmlOutputter.output(document, (Writer)writer);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (null == writer) break block5;
                    writer.close();
                }
            }
            return null;
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }

        private Collection<Element> getSuiteElements(Element rootElement) {
            ArrayList<Element> result = new ArrayList<Element>();
            if (this.isSuiteElement(rootElement)) {
                result.add(rootElement);
            } else {
                for (Element element : rootElement.getChildren()) {
                    if (!this.isSuiteElement(element)) continue;
                    result.add(element);
                }
            }
            return result;
        }

        private void replaceTestCaseElements(Element suiteElement) {
            suiteElement.removeChildren("testcase");
            ArrayList<Element> newTcElements = new ArrayList<Element>();
            for (NvClassResult classResult : this.result.getNvTestSuiteResult(suiteElement.getAttribute("name").getValue()).getResults()) {
                for (NvProfileResult profileResult : classResult.getResults()) {
                    for (NvTestCaseResult testCaseResult : profileResult.getResults()) {
                        newTcElements.add(XmlTestCaseElementCreator.create(classResult.getName(), profileResult.getName(), testCaseResult));
                    }
                }
            }
            Collections.sort(newTcElements, new Comparator<Element>(){

                @Override
                public int compare(Element o1, Element o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    int classComp = o1.getAttribute("classname").getValue().compareToIgnoreCase(o2.getAttribute("classname").getValue());
                    if (classComp == 0) {
                        return o1.getAttribute("name").getValue().compareToIgnoreCase(o2.getAttribute("name").getValue());
                    }
                    return classComp;
                }
            });
            suiteElement.addContent(newTcElements);
        }

        private boolean isSuiteElement(Element element) {
            return element.getName().equals("testsuite");
        }

        private void updateSuiteElement(Element suiteElement) {
            String suiteName = suiteElement.getAttribute("name").getValue();
            NvTestSuiteResult nvSuiteResult = this.result.getNvTestSuiteResult(suiteName);
            if (null != nvSuiteResult) {
                suiteElement.setAttribute("time", String.valueOf(nvSuiteResult.getDuration()));
                suiteElement.setAttribute("skipped", String.valueOf(nvSuiteResult.getSkipCount()));
                suiteElement.setAttribute("failures", String.valueOf(nvSuiteResult.getFailCount()));
                suiteElement.setAttribute("errors", String.valueOf(nvSuiteResult.getErrorCount()));
                suiteElement.setAttribute("tests", String.valueOf(nvSuiteResult.getSkipCount() + nvSuiteResult.getFailCount() + nvSuiteResult.getErrorCount() + nvSuiteResult.getPassCount()));
            }
        }
    }
}

