/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin.results;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.TestResult;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.nvemulation.model.NvNetworkProfile;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvJUnitResult;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvResultsBuilder;
import org.jenkinsci.plugins.nvemulation.plugin.results.NvResultsMerger;

public class NvJUnitResultsHandler {
    private final String JSON_FILE_NAME = "nvResult.json";
    private String reportFilesPattern;
    private JUnitParser parser;
    private NvResultsBuilder aggregator;
    private ObjectMapper objectMapper;

    public NvJUnitResultsHandler(Map<String, Float> thresholdsMap, String reportFilesPattern) {
        this.reportFilesPattern = reportFilesPattern;
        this.parser = new JUnitParser(true, true);
        this.aggregator = new NvResultsBuilder(thresholdsMap);
        this.objectMapper = new ObjectMapper();
    }

    public void handle(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, NvNetworkProfile profile) throws IOException, InterruptedException {
        TestResult testResult = this.parser.parseResult(this.reportFilesPattern, build, build.getWorkspace(), launcher, (TaskListener)listener);
        this.aggregator.aggregate(testResult, profile);
    }

    public void finalizeResults(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        NvJUnitResult result = this.aggregator.finalizeResults();
        this.writeResultToFile(build.getRootDir(), result);
        this.mergeResults(build, result);
    }

    private void writeResultToFile(File rootDir, NvJUnitResult result) throws IOException {
        File resultFile = new File(rootDir, "nvResult.json");
        this.objectMapper.writeValue(resultFile, (Object)result);
    }

    private void mergeResults(AbstractBuild<?, ?> build, NvJUnitResult result) throws IOException, InterruptedException {
        NvResultsMerger.mergeResults(build, this.reportFilesPattern, result);
    }
}

