/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.nvemulation.common.NvTestUtils;
import org.jenkinsci.plugins.nvemulation.model.NvDataHolder;

@Extension
public class NvEmulationRunListener<R extends Run>
extends RunListener<R> {
    public void onCompleted(R r, @Nonnull TaskListener listener) {
        super.onCompleted(r, listener);
        try {
            if (r.getResult().isWorseOrEqualTo(Result.FAILURE) && null != NvDataHolder.getInstance().get(NvTestUtils.getBuildKey(r))) {
                listener.getLogger().println("Build was not completed. Stopping Network Virtualization emulation.");
                NvTestUtils.stopTestEmulation(r, listener);
            }
        }
        catch (AbortException abortException) {
            // empty catch block
        }
    }
}

