/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.plugin;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.nvemulation.common.NvNetworkProfileRegistry;
import org.jenkinsci.plugins.nvemulation.model.BandwidthEnum;
import org.jenkinsci.plugins.nvemulation.model.NvNetworkProfile;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class NetworkProfileSelector
extends AbstractDescribableImpl<NetworkProfileSelector> {
    private final String profileName;

    @DataBoundConstructor
    public NetworkProfileSelector(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkProfileSelector)) {
            return false;
        }
        NetworkProfileSelector that = (NetworkProfileSelector)((Object)o);
        return this.profileName.equals(that.profileName);
    }

    public int hashCode() {
        return this.profileName.hashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<NetworkProfileSelector> {
        private final String TOOLTIP_FORMAT = "Latency (ms): %s\nPacket Loss (%%): %s\nBandwidth In (Kbps): %s\nBandwidth Out (Kbps): %s";
        private String defaultProfileName;
        private String selectedProfileName;

        public DescriptorImpl() {
            this.load();
            this.defaultProfileName = ((ListBoxModel.Option)NvNetworkProfileRegistry.getInstance().getNetworkProfilesAsListModel().get((int)0)).name;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public ListBoxModel doFillProfileNameItems() {
            return NvNetworkProfileRegistry.getInstance().getNetworkProfilesAsListModel();
        }

        public FormValidation doCheckProfileName(@QueryParameter String value) throws IOException, ServletException {
            if (!NvNetworkProfileRegistry.getInstance().exists(value)) {
                return FormValidation.error((String)"Profile does not exist");
            }
            return FormValidation.ok();
        }

        public String getDefaultProfileName() {
            return this.defaultProfileName;
        }

        public String getSelectedProfileName() {
            return this.selectedProfileName;
        }

        @JavaScriptMethod
        public String getTooltip(String profileName) {
            NvNetworkProfile networkProfile = NvNetworkProfileRegistry.getInstance().getNetworkProfile(profileName);
            return String.format("Latency (ms): %s\nPacket Loss (%%): %s\nBandwidth In (Kbps): %s\nBandwidth Out (Kbps): %s", networkProfile.getLatency(), networkProfile.getPacket(), BandwidthEnum.valueOf(networkProfile.getBandwidthIn()).getValue(), BandwidthEnum.valueOf(networkProfile.getBandwidthOut()).getValue());
        }

        public String getDisplayName() {
            return "";
        }
    }
}

