/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.nvemulation.common.NvValidatorUtils;
import org.jenkinsci.plugins.nvemulation.model.BandwidthEnum;
import org.jenkinsci.plugins.nvemulation.model.NvProfileDTO;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@JsonIgnoreProperties(value={"serialVersionUID", "dto"})
public class NvNetworkProfile
extends AbstractDescribableImpl<NvNetworkProfile>
implements Serializable {
    private static final long serialVersionUID = 5600302656112810974L;
    private String profileName;
    private String latency = "0";
    private String packet = "0";
    private String bandwidthIn = BandwidthEnum.UNRESTRICTED.getDisplayText();
    private String bandwidthOut = BandwidthEnum.UNRESTRICTED.getDisplayText();
    private boolean custom = true;
    private NvProfileDTO dto;

    @JsonCreator
    @DataBoundConstructor
    public NvNetworkProfile(@JsonProperty(value="profileName") String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    private void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getLatency() {
        return this.latency;
    }

    @DataBoundSetter
    public void setLatency(String latency) {
        this.latency = latency;
    }

    public String getPacket() {
        return this.packet;
    }

    @DataBoundSetter
    public void setPacket(String packet) {
        this.packet = packet;
    }

    public String getBandwidthIn() {
        return this.bandwidthIn;
    }

    @DataBoundSetter
    public void setBandwidthIn(String bandwidthIn) {
        this.bandwidthIn = bandwidthIn;
    }

    public String getBandwidthOut() {
        return this.bandwidthOut;
    }

    @DataBoundSetter
    public void setBandwidthOut(String bandwidthOut) {
        this.bandwidthOut = bandwidthOut;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public String toString() {
        return "Network Profile{profileName='" + this.profileName + '\'' + ", latency='" + this.latency + '\'' + ", packet='" + this.packet + '\'' + ", bandwidthIn='" + this.bandwidthIn + '\'' + ", bandwidthOut='" + this.bandwidthOut + '\'' + '}' + "\n";
    }

    public NvProfileDTO toDTO() {
        if (null == this.dto) {
            this.dto = new NvProfileDTO(this.profileName);
            this.dto.setLatency(Double.parseDouble(this.latency));
            this.dto.setPacket(Double.parseDouble(this.packet));
            this.dto.setBandwidthIn(BandwidthEnum.valueOf(this.bandwidthIn).getValue());
            this.dto.setBandwidthOut(BandwidthEnum.valueOf(this.bandwidthOut).getValue());
        }
        return this.dto;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<NvNetworkProfile> {
        public static final int MAX_LATENCY_VALUE = 8000;
        public static final int MAX_PACKET_VALUE = 100;

        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckProfileName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a profile name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLatency(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set latency");
            }
            if (!NvValidatorUtils.validateFloatingPoint(value, 8000.0)) {
                return FormValidation.error((String)"Latency must be a positive number between 0 and 8000");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPacket(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set packet loss");
            }
            if (!NvValidatorUtils.validateFloatingPoint(value, 100.0)) {
                return FormValidation.error((String)"Packet loss must be a positive number between 0 and 100");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillBandwidthInItems() {
            return this.getBandwidthItems();
        }

        public ListBoxModel doFillBandwidthOutItems() {
            return this.getBandwidthItems();
        }

        private ListBoxModel getBandwidthItems() {
            ListBoxModel items = new ListBoxModel();
            for (BandwidthEnum bandwidthEnum : BandwidthEnum.values()) {
                items.add(bandwidthEnum.getDisplayText(), bandwidthEnum.name());
            }
            return items;
        }

        public String getDisplayName() {
            return "Network Profile";
        }
    }
}

