/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.common;

import com.hpe.nv.api.NVExceptions;
import com.hpe.nv.api.Test;
import com.hpe.nv.api.Transaction;
import hudson.AbortException;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.nvemulation.model.NvContext;
import org.jenkinsci.plugins.nvemulation.model.NvDataHolder;

public class NvTestUtils {
    private static final String JOB_NAME = "JOB_NAME";

    public static String getBuildKey(Run<?, ?> build) {
        return (String)build.getCharacteristicEnvVars().get((Object)JOB_NAME) + "_" + build.getId();
    }

    public static String getNvTestId(Run<?, ?> build) {
        return NvTestUtils.getBuildKey(build) + "_Test";
    }

    public static void stopTestEmulation(Run<?, ?> run, TaskListener listener) throws AbortException {
        NvContext nvContext = NvDataHolder.getInstance().get(NvTestUtils.getBuildKey(run));
        if (null != nvContext) {
            Test test;
            boolean txStopped = true;
            boolean testStopped = true;
            String errorMessage = "";
            Transaction transaction = nvContext.getTransaction();
            if (null != transaction) {
                try {
                    transaction.stop();
                }
                catch (NVExceptions.ServerErrorException | IOException e) {
                    txStopped = false;
                    e.printStackTrace(listener.getLogger());
                    errorMessage = "Failed to stop transaction. Error: " + e.getMessage() + "\n";
                }
                if (txStopped) {
                    listener.getLogger().println("Successfully stopped transaction.");
                }
            }
            if (null != (test = nvContext.getTest())) {
                try {
                    test.stop();
                    NvDataHolder.getInstance().clear(NvTestUtils.getBuildKey(run));
                }
                catch (NVExceptions.ServerErrorException | IOException e) {
                    testStopped = false;
                    e.printStackTrace(listener.getLogger());
                    errorMessage = errorMessage + "Failed to stop Network Virtualization emulation. Error: " + e.getMessage();
                }
                if (testStopped) {
                    listener.getLogger().println("Network Virtualization emulation was stopped successfully.");
                }
            }
            if (!txStopped || !testStopped) {
                throw new AbortException(errorMessage);
            }
        }
    }
}

