/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nvemulation.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.nvemulation.model.NvNetworkProfile;

public class NvNetworkProfileRegistry {
    public static final String DEFAULT_PROFILES_FILE_NAME = "default_profiles.txt";
    public static final String NONE_PROFILE_NAME = "No Emulation";
    private static NvNetworkProfileRegistry instance;
    private Map<String, NvNetworkProfile> profiles = new HashMap<String, NvNetworkProfile>();
    private Comparator<String> profileNameComparator = new ProfileNameComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NvNetworkProfileRegistry getInstance() {
        if (null != instance) return instance;
        Class<NvNetworkProfileRegistry> clazz = NvNetworkProfileRegistry.class;
        synchronized (NvNetworkProfileRegistry.class) {
            if (null != instance) return instance;
            instance = new NvNetworkProfileRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NvNetworkProfileRegistry() {
        this.registerDefaultProfiles();
    }

    private void registerDefaultProfiles() {
        InputStream is = NvNetworkProfileRegistry.class.getClassLoader().getResourceAsStream(DEFAULT_PROFILES_FILE_NAME);
        try {
            this.register(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void register(InputStream is) throws IOException {
        List profiles = (List)new ObjectMapper().readValue(is, (TypeReference)new TypeReference<List<NvNetworkProfile>>(){});
        for (NvNetworkProfile profile : profiles) {
            profile.setCustom(false);
            this.profiles.put(profile.getProfileName(), profile);
        }
    }

    public synchronized void register(Collection<NvNetworkProfile> profiles) {
        if (null != profiles) {
            for (NvNetworkProfile profile : profiles) {
                NvNetworkProfile existing = this.getNetworkProfile(profile.getProfileName());
                if (null != existing && !existing.isCustom()) continue;
                profile.setCustom(true);
                this.profiles.put(profile.getProfileName(), profile);
            }
        }
    }

    public void unregisterCustom() {
        ArrayList<String> profilesToRemove = new ArrayList<String>();
        for (NvNetworkProfile profile : this.profiles.values()) {
            if (!profile.isCustom()) continue;
            profilesToRemove.add(profile.getProfileName());
        }
        for (String profileName : profilesToRemove) {
            this.profiles.remove(profileName);
        }
    }

    public ListBoxModel getNetworkProfilesAsListModel() {
        ListBoxModel items = new ListBoxModel();
        ArrayList<String> names = new ArrayList<String>(this.profiles.keySet());
        Collections.sort(names, this.profileNameComparator);
        items.add(NONE_PROFILE_NAME, NONE_PROFILE_NAME);
        for (String name : names) {
            if (name.equals(NONE_PROFILE_NAME)) continue;
            items.add(name, name);
        }
        return items;
    }

    public NvNetworkProfile getNetworkProfile(String profileName) {
        return this.profiles.get(profileName);
    }

    public List<NvNetworkProfile> getNetworkProfiles(Collection<String> profileNames) {
        ArrayList<NvNetworkProfile> result = new ArrayList<NvNetworkProfile>();
        if (null != profileNames) {
            for (String profileName : profileNames) {
                result.add(this.profiles.get(profileName));
            }
        }
        return result;
    }

    public boolean exists(String profileName) {
        return null != this.profiles.get(profileName);
    }

    private static class ProfileNameComparator
    implements Comparator<String> {
        private ProfileNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

