/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.util;

import com.google.common.base.Preconditions;
import hudson.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Resolve {
    private static Map<String, String> defaultValues = new HashMap<String, String>();

    public static String resolveBuiltin(String input) {
        return Resolve.resolveBuiltinWithCustom((String)Preconditions.checkNotNull((Object)input), Collections.emptyMap());
    }

    public static String resolveBuiltinWithCustom(String input, Map<String, String> customEnvironment) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull(customEnvironment);
        HashMap<String, String> combinedEnvironment = new HashMap<String, String>();
        combinedEnvironment.putAll(defaultValues);
        combinedEnvironment.putAll(customEnvironment);
        return Resolve.resolveCustom(input, combinedEnvironment);
    }

    public static String resolveCustom(String input, Map<String, String> customEnvironment) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull(customEnvironment);
        return Util.replaceMacro((String)input, customEnvironment);
    }

    private Resolve() {
        throw new UnsupportedOperationException("Not intended for instantiation");
    }

    static {
        defaultValues.put("BUILD_NUMBER", "42");
        defaultValues.put("BUILD_ID", "2005-08-22_23-59-59");
        defaultValues.put("BUILD_URL", "http://buildserver/jenkins/job/MyJobName/666/");
        defaultValues.put("NODE_NAME", "master");
        defaultValues.put("JOB_NAME", "hello world");
        defaultValues.put("BUILD_TAG", "jenkins-job name-42");
        defaultValues.put("JENKINS_URL", "https://build.mydomain.org/");
        defaultValues.put("EXECUTOR_NUMBER", "3");
        defaultValues.put("JAVA_HOME", "/usr/bin/");
        defaultValues.put("WORKSPACE", "/tmp/jenkins/");
        defaultValues.put("SVN_REVISION", "r1234");
        defaultValues.put("CVS_BRANCH", "TODO");
        defaultValues.put("GIT_COMMIT", "a48b5b3273a1");
        defaultValues.put("GIT_BRANCH", "origin/master");
        defaultValues = Collections.unmodifiableMap(defaultValues);
    }
}

