/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import hudson.util.Secret;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;

@Deprecated
public class KeyUtils {
    private KeyUtils() {
    }

    public static File createKeyFile(String prefix, String suffix) throws IOException {
        File keyFolder = new File(Jenkins.getInstance().getRootDir(), "gauth");
        if (keyFolder.exists() || keyFolder.mkdirs()) {
            File result = File.createTempFile(prefix, suffix, keyFolder);
            if (result == null) {
                throw new IOException("Failed to create key file");
            }
            KeyUtils.updatePermissions(result);
            return result;
        }
        throw new IOException("Failed to create key folder");
    }

    public static void updatePermissions(File file) throws IOException {
        if (file == null || !file.exists()) {
            return;
        }
        if (!(file.setReadable(false, false) && file.setWritable(false, false) && file.setReadable(true, true) && file.setWritable(true, true))) {
            throw new IOException("Failed to update key file permissions");
        }
    }

    public static void writeKeyToFileEncoded(String key, File file) throws IOException {
        if (key == null || file == null) {
            return;
        }
        Secret encoded = Secret.fromString((String)key);
        KeyUtils.writeKeyToFile(IOUtils.toInputStream((String)encoded.getEncryptedValue(), (Charset)StandardCharsets.UTF_8), file);
    }

    public static void writeKeyToFile(InputStream keyStream, File file) throws IOException {
        if (keyStream == null || file == null) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IOUtils.copy((InputStream)keyStream, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }
}

