/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.googlelogin;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.User;
import hudson.security.SecurityRealm;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.jenkinsci.plugins.googlelogin.GoogleUserInfo;
import org.jenkinsci.plugins.googlelogin.OAuthSession;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class GoogleOAuth2SecurityRealm
extends SecurityRealm {
    private static final String SCOPE = "profile email";
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final GenericUrl TOKEN_SERVER_URL = new GenericUrl("https://accounts.google.com/o/oauth2/token");
    private static final String AUTHORIZATION_SERVER_URL = "https://accounts.google.com/o/oauth2/auth";
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final String SESSION_NAME = GoogleOAuth2SecurityRealm.class.getName() + ".OAuthSession";
    private final String clientId;
    private final Secret clientSecret;
    private final String domain;
    private boolean rootURLFromRequest;

    @DataBoundConstructor
    public GoogleOAuth2SecurityRealm(String clientId, String clientSecret, String domain) throws IOException {
        this.clientId = clientId;
        this.clientSecret = Secret.fromString((String)clientSecret);
        this.domain = Util.fixEmptyAndTrim((String)domain);
    }

    public boolean isRootURLFromRequest() {
        return this.rootURLFromRequest;
    }

    @DataBoundSetter
    public void setRootURLFromRequest(boolean rootURLFromRequest) {
        this.rootURLFromRequest = rootURLFromRequest;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        });
    }

    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        return "securityRealm/loggedOut";
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doCommenceLogin(StaplerRequest request, @QueryParameter String from, @Header(value="Referer") String referer) throws IOException {
        final String redirectOnFinish = this.getRedirectOnFinish(from, referer);
        final AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(BearerToken.queryParameterAccessMethod(), HTTP_TRANSPORT, JSON_FACTORY, TOKEN_SERVER_URL, (HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientId, this.clientSecret.getPlainText()), this.clientId, AUTHORIZATION_SERVER_URL).setScopes(Arrays.asList(SCOPE)).build();
        OAuthSession oAuthSession = new OAuthSession(from, this.buildOAuthRedirectUrl(), this.domain){

            @Override
            public HttpResponse onSuccess(String authorizationCode) {
                try {
                    IdTokenResponse response = IdTokenResponse.execute((TokenRequest)flow.newTokenRequest(authorizationCode).setRedirectUri(GoogleOAuth2SecurityRealm.this.buildOAuthRedirectUrl()));
                    IdToken idToken = IdToken.parse((JsonFactory)JSON_FACTORY, (String)response.getIdToken());
                    Object hd = idToken.getPayload().get((Object)"hd");
                    if (!GoogleOAuth2SecurityRealm.this.isDomainValid(hd)) {
                        return HttpResponses.errorWithoutStack((int)401, (String)"Unauthorized");
                    }
                    final Credential credential = flow.createAndStoreCredential((TokenResponse)response, null);
                    HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

                        public void initialize(HttpRequest request) throws IOException {
                            credential.initialize(request);
                            request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
                        }
                    });
                    GenericUrl url = new GenericUrl("https://www.googleapis.com/userinfo/v2/me");
                    HttpRequest request = requestFactory.buildGetRequest(url);
                    GoogleUserInfo info = (GoogleUserInfo)((Object)request.execute().parseAs(GoogleUserInfo.class));
                    GrantedAuthority[] authorities = new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY};
                    UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)info.getEmail(), (Object)"", authorities);
                    Stapler.getCurrentRequest().getSession().invalidate();
                    Stapler.getCurrentRequest().getSession();
                    SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                    User u = User.get((String)token.getName());
                    info.updateProfile(u);
                    SecurityListener.fireLoggedIn((String)token.getName());
                    return new HttpRedirect(redirectOnFinish);
                }
                catch (IOException e) {
                    return HttpResponses.error((int)500, (Throwable)e);
                }
            }
        };
        request.getSession().setAttribute(SESSION_NAME, (Object)oAuthSession);
        return oAuthSession.doCommenceLogin(flow);
    }

    String getRedirectOnFinish(String from, String referer) {
        String redirectOnFinish = from != null && Util.isSafeToRedirectTo((String)from) ? from : (referer != null && Util.isSafeToRedirectTo((String)referer) ? referer : this.getRootURL());
        return redirectOnFinish;
    }

    @VisibleForTesting
    boolean isDomainValid(Object tokenDomain) {
        if (this.domain == null) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.domain, ",");
        while (tokenizer.hasMoreElements()) {
            String domainToTest = tokenizer.nextToken().trim();
            if (!domainToTest.equals(tokenDomain)) continue;
            return true;
        }
        return false;
    }

    private String buildOAuthRedirectUrl() {
        String rootUrl = this.getRootURL();
        if (rootUrl == null) {
            throw new NullPointerException("Jenkins root url should not be null");
        }
        return rootUrl + "securityRealm/finishLogin";
    }

    private String getRootURL() {
        if (this.rootURLFromRequest) {
            return Jenkins.getInstance().getRootUrlFromRequest();
        }
        return Jenkins.getInstance().getRootUrl();
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        OAuthSession oAuthSession = (OAuthSession)request.getSession().getAttribute(SESSION_NAME);
        if (oAuthSession != null) {
            return oAuthSession.doFinishLogin(request);
        }
        return new Failure("Your Jenkins session has expired. Please login again.");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "Login with Google";
        }
    }
}

