/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine.client;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.cloud.graphite.platforms.plugin.client.ClientFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.k8sengine.CredentialsUtil;
import com.google.jenkins.plugins.k8sengine.client.Messages;
import com.google.jenkins.plugins.k8sengine.client.RetryHttpInitializerWrapper;
import hudson.AbortException;
import hudson.model.ItemGroup;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;

public class ClientUtil {
    private static final String APPLICATION_NAME = "jenkins-google-gke-plugin";

    public static ClientFactory getClientFactory(ItemGroup itemGroup, ImmutableList<DomainRequirement> domainRequirements, String credentialsId, Optional<HttpTransport> transport) throws AbortException {
        ClientFactory clientFactory;
        Preconditions.checkNotNull((Object)itemGroup);
        Preconditions.checkNotNull(domainRequirements);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        Preconditions.checkNotNull(transport);
        try {
            GoogleRobotCredentials robotCreds = CredentialsUtil.getRobotCredentials(itemGroup, domainRequirements, credentialsId);
            Credential googleCredential = CredentialsUtil.getGoogleCredential(robotCreds);
            clientFactory = new ClientFactory(transport, (HttpRequestInitializer)new RetryHttpInitializerWrapper(googleCredential), APPLICATION_NAME);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new AbortException(Messages.ClientFactory_FailedToInitializeHTTPTransport(ex));
        }
        return clientFactory;
    }

    public static ClientFactory getClientFactory(ItemGroup itemGroup, String credentialsId) throws AbortException {
        return ClientUtil.getClientFactory(itemGroup, (ImmutableList<DomainRequirement>)ImmutableList.of(), credentialsId, Optional.empty());
    }
}

