/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.container.model.Cluster;
import com.google.cloud.graphite.platforms.plugin.client.ClientFactory;
import com.google.cloud.graphite.platforms.plugin.client.CloudResourceManagerClient;
import com.google.cloud.graphite.platforms.plugin.client.ContainerClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2Credentials;
import com.google.jenkins.plugins.k8sengine.ClusterUtil;
import com.google.jenkins.plugins.k8sengine.CredentialsUtil;
import com.google.jenkins.plugins.k8sengine.KubeConfig;
import com.google.jenkins.plugins.k8sengine.KubectlWrapper;
import com.google.jenkins.plugins.k8sengine.Manifests;
import com.google.jenkins.plugins.k8sengine.Messages;
import com.google.jenkins.plugins.k8sengine.VerificationTask;
import com.google.jenkins.plugins.k8sengine.client.ClientUtil;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class KubernetesEngineBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    public static final long serialVersionUID = 333L;
    private static final Logger LOGGER = Logger.getLogger(KubernetesEngineBuilder.class.getName());
    static final String EMPTY_NAME = "- none -";
    static final String EMPTY_VALUE = "";
    static final int DEFAULT_VERIFY_TIMEOUT_MINUTES = 5;
    static final String METRICS_LABEL_KEY = "app.kubernetes.io/managed-by";
    static final String METRICS_LABEL_VALUE = "graphite-jenkins-gke";
    static final ImmutableSet<String> METRICS_TARGET_TYPES = ImmutableSet.of((Object)"Deployment", (Object)"Service", (Object)"ReplicaSet");
    private String credentialsId;
    private String projectId;
    @Deprecated
    private String zone;
    private String location;
    private String clusterName;
    private String namespace;
    private String manifestPattern;
    private boolean verifyDeployments;
    private int verifyTimeoutInMinutes = 5;
    private boolean verifyServices;
    private boolean isTestCleanup;
    private boolean verboseLogging = false;
    private LinkedList<KubeConfigAfterBuildStep> afterBuildStepStack;

    @DataBoundConstructor
    public KubernetesEngineBuilder() {
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        this.credentialsId = credentialsId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    @DataBoundSetter
    public void setProjectId(String projectId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        this.projectId = projectId;
    }

    @Deprecated
    public String getZone() {
        return this.getLocation();
    }

    @Deprecated
    @DataBoundSetter
    public void setZone(String zone) {
        this.setLocation(zone);
    }

    public String getLocation() {
        this.setupLocation();
        return this.location;
    }

    @DataBoundSetter
    public void setLocation(String location) {
        this.setupLocation();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        this.location = location;
    }

    private void setupLocation() {
        if (Strings.isNullOrEmpty((String)this.location)) {
            this.location = this.zone;
            this.zone = null;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    @DataBoundSetter
    public void setClusterName(String clusterName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clusterName) ? 1 : 0) != 0);
        this.clusterName = clusterName;
    }

    public String getCluster() {
        this.setupLocation();
        return ClusterUtil.toNameAndLocation(this.clusterName, this.location);
    }

    @DataBoundSetter
    public void setCluster(String cluster) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cluster) ? 1 : 0) != 0);
        String[] values = ClusterUtil.valuesFromNameAndLocation(cluster);
        this.setClusterName(values[0]);
        this.setLocation(values[1]);
    }

    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = namespace == null ? EMPTY_VALUE : namespace;
    }

    public String getManifestPattern() {
        return this.manifestPattern;
    }

    @DataBoundSetter
    public void setManifestPattern(String manifestPattern) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)manifestPattern) ? 1 : 0) != 0);
        this.manifestPattern = manifestPattern;
    }

    @DataBoundSetter
    public void setVerifyDeployments(boolean verifyDeployments) {
        this.verifyDeployments = verifyDeployments;
    }

    public boolean isVerifyDeployments() {
        return this.verifyDeployments;
    }

    @DataBoundSetter
    public void setVerifyServices(boolean verifyServices) {
        this.verifyServices = verifyServices;
    }

    public boolean isVerifyServices() {
        return this.verifyServices;
    }

    public int getVerifyTimeoutInMinutes() {
        return this.verifyTimeoutInMinutes;
    }

    @DataBoundSetter
    public void setVerifyTimeoutInMinutes(int verifyTimeoutInMinutes) {
        this.verifyTimeoutInMinutes = verifyTimeoutInMinutes;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    @DataBoundSetter
    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    @VisibleForTesting
    void pushAfterBuildStep(KubeConfigAfterBuildStep afterBuildStep) {
        if (this.afterBuildStepStack == null) {
            this.afterBuildStepStack = new LinkedList();
        }
        this.afterBuildStepStack.push(afterBuildStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        LOGGER.log(Level.INFO, String.format("GKE Deploying, projectId: %s cluster: %s location: %s", this.projectId, this.clusterName, this.getLocation()));
        ContainerClient client = KubernetesEngineBuilder.getContainerClient(this.credentialsId);
        Cluster cluster = client.getCluster(this.projectId, this.getLocation(), this.clusterName);
        KubeConfig kubeConfig = KubeConfig.fromCluster(this.projectId, cluster, CredentialsUtil.getAccessToken(this.credentialsId));
        KubectlWrapper kubectl = new KubectlWrapper.Builder().workspace(workspace).launcher(launcher).kubeConfig(kubeConfig).namespace(this.namespace).verboseLogging(this.verboseLogging).build();
        FilePath manifestFile = workspace.child(this.manifestPattern);
        KubernetesEngineBuilder.addMetricsLabel(manifestFile);
        kubectl.runKubectlCommand("apply", (ImmutableList<String>)ImmutableList.of((Object)"-f", (Object)manifestFile.getRemote()));
        try {
            if (this.verifyDeployments && !this.verify(kubectl, this.manifestPattern, workspace, listener.getLogger())) {
                throw new AbortException(Messages.KubernetesEngineBuilder_KubernetesObjectsNotVerified());
            }
        }
        finally {
            if (this.afterBuildStepStack != null) {
                while (!this.afterBuildStepStack.isEmpty()) {
                    this.afterBuildStepStack.pop().perform(kubeConfig, run, workspace, launcher, listener);
                }
            }
        }
    }

    @VisibleForTesting
    static void addMetricsLabel(FilePath manifestFile) throws InterruptedException, IOException {
        Manifests manifests = Manifests.fromFile(manifestFile);
        for (Manifests.ManifestObject manifest : manifests.getObjectManifestsOfKinds((Set<String>)METRICS_TARGET_TYPES)) {
            manifest.addLabel(METRICS_LABEL_KEY, METRICS_LABEL_VALUE);
        }
        manifests.write();
    }

    private boolean verify(KubectlWrapper kubectl, String manifestPattern, FilePath workspace, PrintStream consoleLogger) throws InterruptedException, IOException {
        LOGGER.log(Level.INFO, String.format("GKE verifying deployment to, projectId: %s cluster: %s location: %s manifests: %s", this.projectId, this.clusterName, this.getLocation(), workspace.child(manifestPattern)));
        consoleLogger.println(String.format("Verifying manifests: %s", workspace.child(manifestPattern)));
        Manifests manifests = Manifests.fromFile(workspace.child(manifestPattern));
        List<Manifests.ManifestObject> manifestObjects = manifests.getObjectManifestsOfKinds((Set<String>)ImmutableSet.of((Object)"deployment"));
        consoleLogger.println(Messages.KubernetesEngineBuilder_VerifyingNObjects(manifestObjects.size()));
        return VerificationTask.verifyObjects(kubectl, manifestObjects, consoleLogger, this.verifyTimeoutInMinutes);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private static void selectOption(ListBoxModel listBoxModel, String optionValue) {
        Optional<ListBoxModel.Option> item;
        if (!Strings.isNullOrEmpty((String)optionValue) && (item = listBoxModel.stream().filter(option -> optionValue.equals(option.value)).findFirst()).isPresent()) {
            item.get().selected = true;
            return;
        }
        item = listBoxModel.stream().filter(option -> !Strings.isNullOrEmpty((String)option.value)).findFirst();
        item.ifPresent(i -> {
            i.selected = true;
        });
    }

    private static ContainerClient getContainerClient(String credentialsId) throws AbortException {
        return ClientUtil.getClientFactory((ItemGroup)Jenkins.get(), credentialsId).containerClient();
    }

    @FunctionalInterface
    static interface KubeConfigAfterBuildStep
    extends Serializable {
        public void perform(KubeConfig var1, Run<?, ?> var2, FilePath var3, Launcher var4, TaskListener var5) throws AbortException, InterruptedException, IOException;
    }

    @Symbol(value={"kubernetesEngineDeploy"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private ClientFactory clientFactory;
        private String defaultProjectId;
        private String credentialsId;

        @Nonnull
        public String getDisplayName() {
            return Messages.KubernetesEngineBuilder_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @VisibleForTesting
        ClientFactory getClientFactory(Jenkins context, String credentialsId) throws AbortException {
            if (this.clientFactory == null || this.updateCredentialsId(credentialsId)) {
                this.clientFactory = ClientUtil.getClientFactory((ItemGroup)context, credentialsId);
            }
            return this.clientFactory;
        }

        @VisibleForTesting
        String getDefaultProjectId(Jenkins context, String credentialsId) throws AbortException {
            if (this.defaultProjectId == null || this.updateCredentialsId(credentialsId)) {
                this.defaultProjectId = CredentialsUtil.getDefaultProjectId((ItemGroup)context, credentialsId);
            }
            return this.defaultProjectId;
        }

        private boolean updateCredentialsId(String credentialsId) {
            if (this.credentialsId == null || !this.credentialsId.equals(credentialsId)) {
                this.credentialsId = credentialsId;
                return true;
            }
            return false;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context) {
            if (context == null || !context.hasPermission(CredentialsProvider.VIEW)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)context, StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(GoogleOAuth2Credentials.class));
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Jenkins context, @QueryParameter(value="credentialsId") String credentialsId) {
            if (credentialsId.isEmpty()) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_NoCredential());
            }
            try {
                CredentialsUtil.getAccessToken((ItemGroup)context, credentialsId);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, Messages.KubernetesEngineBuilder_CredentialAuthFailed(), ex);
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_CredentialAuthFailed());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillProjectIdItems(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") String projectId, @QueryParameter(value="credentialsId") String credentialsId) {
            String defaultProjectId;
            ClientFactory clientFactory;
            ListBoxModel items = new ListBoxModel();
            items.add(KubernetesEngineBuilder.EMPTY_NAME, KubernetesEngineBuilder.EMPTY_VALUE);
            if (Strings.isNullOrEmpty((String)credentialsId)) {
                return items;
            }
            try {
                clientFactory = this.getClientFactory(context, credentialsId);
                defaultProjectId = this.getDefaultProjectId(context, credentialsId);
            }
            catch (AbortException | RuntimeException ex) {
                LOGGER.log(Level.SEVERE, Messages.KubernetesEngineBuilder_CredentialAuthFailed(), ex);
                items.clear();
                items.add(Messages.KubernetesEngineBuilder_CredentialAuthFailed(), KubernetesEngineBuilder.EMPTY_VALUE);
                return items;
            }
            try {
                CloudResourceManagerClient client = clientFactory.cloudResourceManagerClient();
                ImmutableList projects = client.listProjects();
                if (projects.isEmpty()) {
                    return items;
                }
                projects.stream().filter(p -> !p.getProjectId().equals(defaultProjectId)).forEach(p -> items.add(p.getProjectId()));
                if (Strings.isNullOrEmpty((String)defaultProjectId)) {
                    KubernetesEngineBuilder.selectOption(items, projectId);
                    return items;
                }
                if (projects.size() == items.size() && Strings.isNullOrEmpty((String)projectId)) {
                    items.add((Object)new ListBoxModel.Option(defaultProjectId, defaultProjectId, true));
                } else {
                    items.add(defaultProjectId);
                    KubernetesEngineBuilder.selectOption(items, projectId);
                }
                return items;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, Messages.KubernetesEngineBuilder_ProjectIDFillError(), ioe);
                items.clear();
                items.add(Messages.KubernetesEngineBuilder_ProjectIDFillError(), KubernetesEngineBuilder.EMPTY_VALUE);
                return items;
            }
        }

        public FormValidation doCheckProjectId(@AncestorInPath Jenkins context, @QueryParameter(value="projectId") String projectId, @QueryParameter(value="credentialsId") String credentialsId) {
            ClientFactory clientFactory;
            if (Strings.isNullOrEmpty((String)credentialsId) && Strings.isNullOrEmpty((String)projectId)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ProjectIDRequired());
            }
            if (Strings.isNullOrEmpty((String)credentialsId)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ProjectCredentialIDRequired());
            }
            try {
                clientFactory = this.getClientFactory(context, credentialsId);
            }
            catch (AbortException | RuntimeException e) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_CredentialAuthFailed());
            }
            try {
                CloudResourceManagerClient client = clientFactory.cloudResourceManagerClient();
                ImmutableList projects = client.listProjects();
                if (Strings.isNullOrEmpty((String)projectId)) {
                    return FormValidation.error((String)Messages.KubernetesEngineBuilder_ProjectIDRequired());
                }
                Optional<Project> matchingProject = projects.stream().filter(p -> projectId.equals(p.getProjectId())).findFirst();
                if (!matchingProject.isPresent()) {
                    return FormValidation.error((String)Messages.KubernetesEngineBuilder_ProjectIDNotUnderCredential());
                }
            }
            catch (IOException ioe) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ProjectIDVerificationError());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillClusterItems(@AncestorInPath Jenkins context, @QueryParameter(value="cluster") String cluster, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="projectId") String projectId) {
            ClientFactory clientFactory;
            ListBoxModel items = new ListBoxModel();
            items.add(KubernetesEngineBuilder.EMPTY_NAME, KubernetesEngineBuilder.EMPTY_VALUE);
            if (Strings.isNullOrEmpty((String)credentialsId) || Strings.isNullOrEmpty((String)projectId)) {
                return items;
            }
            try {
                clientFactory = this.getClientFactory(context, credentialsId);
            }
            catch (AbortException | RuntimeException ex) {
                LOGGER.log(Level.SEVERE, Messages.KubernetesEngineBuilder_CredentialAuthFailed(), ex);
                items.clear();
                items.add(Messages.KubernetesEngineBuilder_CredentialAuthFailed(), KubernetesEngineBuilder.EMPTY_VALUE);
                return items;
            }
            try {
                ContainerClient client = clientFactory.containerClient();
                ImmutableList clusters = client.listAllClusters(projectId);
                if (clusters.isEmpty()) {
                    return items;
                }
                clusters.forEach(c -> items.add(ClusterUtil.toNameAndLocation(c)));
                KubernetesEngineBuilder.selectOption(items, cluster);
                return items;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, Messages.KubernetesEngineBuilder_ClusterFillError(), ioe);
                items.clear();
                items.add(Messages.KubernetesEngineBuilder_ClusterFillError(), KubernetesEngineBuilder.EMPTY_VALUE);
                return items;
            }
        }

        public FormValidation doCheckCluster(@AncestorInPath Jenkins context, @QueryParameter(value="cluster") String cluster, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="projectId") String projectId) {
            ClientFactory clientFactory;
            if (Strings.isNullOrEmpty((String)credentialsId) && Strings.isNullOrEmpty((String)cluster)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ClusterRequired());
            }
            if (Strings.isNullOrEmpty((String)credentialsId)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ClusterCredentialIDRequired());
            }
            try {
                clientFactory = this.getClientFactory(context, credentialsId);
            }
            catch (AbortException | RuntimeException ex) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_CredentialAuthFailed());
            }
            if (Strings.isNullOrEmpty((String)projectId) && Strings.isNullOrEmpty((String)cluster)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ClusterRequired());
            }
            if (Strings.isNullOrEmpty((String)projectId)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ClusterProjectIDRequired());
            }
            try {
                ContainerClient client = clientFactory.containerClient();
                ImmutableList clusters = client.listAllClusters(projectId);
                if (Strings.isNullOrEmpty((String)cluster)) {
                    return FormValidation.error((String)Messages.KubernetesEngineBuilder_ClusterRequired());
                }
                if (clusters.size() == 0) {
                    return FormValidation.error((String)Messages.KubernetesEngineBuilder_NoClusterInProject());
                }
                Optional<Cluster> clusterOption = clusters.stream().filter(c -> cluster.equals(ClusterUtil.toNameAndLocation(c))).findFirst();
                if (!clusterOption.isPresent()) {
                    return FormValidation.error((String)Messages.KubernetesEngineBuilder_ClusterNotInProject());
                }
            }
            catch (IOException ioe) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ClusterVerificationError());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNamespace(@QueryParameter(value="namespace") String namespace) {
            if (!Strings.isNullOrEmpty((String)namespace) && !namespace.matches("[a-z0-9]([-a-z0-9]*[a-z0-9])?")) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_NamespaceInvalid());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckManifestPattern(@QueryParameter(value="manifestPattern") String manifestPattern) {
            if (Strings.isNullOrEmpty((String)manifestPattern)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_ManifestRequired());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVerifyTimeoutInMinutes(@QueryParameter(value="verifyTimeoutInMinutes") String verifyTimeoutInMinutes) {
            if (Strings.isNullOrEmpty((String)verifyTimeoutInMinutes)) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_VerifyTimeoutInMinutesRequired());
            }
            if (!verifyTimeoutInMinutes.matches("([1-9]\\d*)")) {
                return FormValidation.error((String)Messages.KubernetesEngineBuilder_VerifyTimeoutInMinutesFormatError());
            }
            return FormValidation.ok();
        }
    }
}

