/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine.client;

import com.google.api.services.container.Container;
import com.google.api.services.container.model.Cluster;
import com.google.api.services.container.model.ListClustersResponse;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class ContainerClient {
    private static final String LOCATION_WILDCARD = "-";
    private final Container container;

    public ContainerClient(Container container) {
        this.container = (Container)Preconditions.checkNotNull((Object)container);
    }

    public Cluster getCluster(String projectId, String location, String cluster) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cluster) ? 1 : 0) != 0);
        return (Cluster)this.container.projects().locations().clusters().get(ContainerClient.toApiName(projectId, location, cluster)).execute();
    }

    public List<Cluster> listAllClusters(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        List clusters = ((ListClustersResponse)this.container.projects().locations().clusters().list(ContainerClient.toApiParent(projectId)).execute()).getClusters();
        if (clusters == null) {
            return ImmutableList.of();
        }
        clusters.sort(Comparator.comparing(Cluster::getName));
        return ImmutableList.copyOf((Collection)clusters);
    }

    private static String toApiName(String projectId, String location, String clusterName) {
        return String.format("projects/%s/locations/%s/clusters/%s", projectId, location, clusterName);
    }

    private static String toApiParent(String projectId) {
        return String.format("projects/%s/locations/%s", projectId, LOCATION_WILDCARD);
    }
}

