/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import com.google.api.services.container.model.Cluster;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

class ClusterUtil {
    ClusterUtil() {
    }

    static String toNameAndLocation(Cluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        return ClusterUtil.toNameAndLocation(cluster.getName(), cluster.getLocation());
    }

    static String toNameAndLocation(String name, String location) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        return String.format("%s (%s)", name, location);
    }

    @VisibleForTesting
    static Cluster fromNameAndLocation(String nameAndLocation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)nameAndLocation) ? 1 : 0) != 0);
        String[] values = ClusterUtil.valuesFromNameAndLocation(nameAndLocation);
        return new Cluster().setName(values[0]).setLocation(values[1]);
    }

    static String[] valuesFromNameAndLocation(String nameAndLocation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)nameAndLocation) ? 1 : 0) != 0);
        String[] clusters = nameAndLocation.split(" [(]");
        if (clusters.length != 2) {
            throw new IllegalArgumentException("nameAndLocation should be of the form 'name (location)'");
        }
        clusters[1] = clusters[1].substring(0, clusters[1].length() - 1);
        return clusters;
    }
}

