/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.volume.zip;

import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

class ZipExtractor
implements Volume.Extractor {
    private static final Logger logger = Logger.getLogger(ZipExtractor.class.getName());
    private final ZipFile zipFile;
    private final Path zipPath;
    private boolean closed = false;

    ZipExtractor(Path zip) throws IOException {
        this.zipPath = (Path)Preconditions.checkNotNull((Object)zip);
        String string = String.valueOf(this.zipPath);
        logger.finer(new StringBuilder(32 + String.valueOf(string).length()).append("Extracting zip volume for path: ").append(string).toString());
        this.zipFile = new ZipFile(this.zipPath.toFile());
    }

    @Override
    public Iterator<Volume.Entry> iterator() {
        final Enumeration entriesInPhysicalOrder = this.zipFile.getEntriesInPhysicalOrder();
        return new Iterator<Volume.Entry>(){

            @Override
            public boolean hasNext() {
                Preconditions.checkState((!ZipExtractor.this.closed ? 1 : 0) != 0, (Object)"Volume closed");
                return entriesInPhysicalOrder.hasMoreElements();
            }

            @Override
            public Volume.Entry next() {
                Preconditions.checkState((!ZipExtractor.this.closed ? 1 : 0) != 0, (Object)"Volume closed");
                return new ZipVolumeEntry(ZipExtractor.this.zipFile, (ZipArchiveEntry)entriesInPhysicalOrder.nextElement());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported by this iterator");
            }
        };
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Volume already closed");
        String string = String.valueOf(this.zipPath);
        logger.finer(new StringBuilder(32 + String.valueOf(string).length()).append("Closing zip extractor for path: ").append(string).toString());
        this.zipFile.close();
        this.closed = true;
    }

    private static class ZipVolumeEntry
    implements Volume.Entry {
        private final ZipFile zipFile;
        private final ZipArchiveEntry zipArchiveEntry;

        private ZipVolumeEntry(ZipFile zipFile, ZipArchiveEntry zipArchiveEntry) {
            this.zipFile = zipFile;
            this.zipArchiveEntry = zipArchiveEntry;
        }

        @Override
        public String getName() {
            String entryName = this.zipArchiveEntry.getName();
            if (this.isDirectory() && entryName.endsWith("/")) {
                entryName = entryName.substring(0, entryName.length() - 1);
            }
            return entryName;
        }

        @Override
        public boolean isDirectory() {
            return this.zipArchiveEntry.isDirectory();
        }

        @Override
        public boolean isSymlink() {
            return this.zipArchiveEntry.isUnixSymlink();
        }

        @Override
        public void extractTo(Path target) throws IOException {
            if (this.isDirectory()) {
                this.extractDirectory(target);
            } else {
                Path parentDir = target.getParent();
                if (parentDir != null) {
                    Files.createDirectories(parentDir, new FileAttribute[0]);
                }
                if (this.isSymlink()) {
                    this.extractSymlink(target);
                } else {
                    this.extractRegularFile(target);
                }
            }
        }

        private void extractDirectory(Path target) throws IOException {
            String string = String.valueOf(target);
            logger.finer(new StringBuilder(22 + String.valueOf(string).length()).append("Extracting directory: ").append(string).toString());
            Files.createDirectories(target, new FileAttribute[0]);
        }

        private void extractSymlink(Path target) throws IOException {
            String string = String.valueOf(target);
            logger.finer(new StringBuilder(20 + String.valueOf(string).length()).append("Extracting symlink: ").append(string).toString());
            String unixSymlink = this.zipFile.getUnixSymlink(this.zipArchiveEntry);
            Path symlinkPath = target.getFileSystem().getPath(unixSymlink, new String[0]);
            Files.deleteIfExists(target);
            Files.createSymbolicLink(target, symlinkPath, new FileAttribute[0]);
        }

        private void extractRegularFile(Path target) throws IOException {
            String string = String.valueOf(target);
            logger.finer(new StringBuilder(17 + String.valueOf(string).length()).append("Extracting file: ").append(string).toString());
            try (InputStream inputStream = this.zipFile.getInputStream(this.zipArchiveEntry);){
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

