/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.storage;

import com.google.api.client.util.Lists;
import com.google.jenkins.plugins.persistentmaster.storage.Storage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GcloudGcsStorage
implements Storage {
    private static final Logger logger = Logger.getLogger(GcloudGcsStorage.class.getName());
    private static final String LAST_BACKUP_FILE = "last-backup";
    private static final String EXISTING_FILE_METADATA = "existing-files-metadata";
    private static final String COMMENT_PREFIX = "#";
    private static final String COMMENT_LINE = "# This file contains the filename of the last backup.";
    private static final String EXISTING_FILES_COMMENT_LINE = "# This file contains the existing files meta data.";
    private static final String GSUTIL_CMD = "gsutil";
    private static final String TMP_DIR_PREFIX = "persistent-master-backup-plugin";
    private final String gsUrlPrefix;

    public GcloudGcsStorage(String bucketName) {
        this.gsUrlPrefix = new StringBuilder(6 + String.valueOf(bucketName).length()).append("gs://").append(bucketName).append("/").toString();
    }

    @Override
    public void storeFile(Path localFile, String filename) throws IOException {
        String string = String.valueOf(localFile);
        logger.finer(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(filename).length()).append("Storing local file: ").append(string).append(" with filename: ").append(filename).toString());
        String[] stringArray = new String[3];
        stringArray[0] = "cp";
        stringArray[1] = localFile.toString();
        String string2 = String.valueOf(this.gsUrlPrefix);
        String string3 = String.valueOf(filename);
        stringArray[2] = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        this.gsutil(stringArray);
    }

    @Override
    public void loadFile(String filename, Path target) throws IOException {
        String string = String.valueOf(target);
        logger.finer(new StringBuilder(30 + String.valueOf(filename).length() + String.valueOf(string).length()).append("Loading filename: ").append(filename).append(" to target: ").append(string).toString());
        String[] stringArray = new String[3];
        stringArray[0] = "cp";
        String string2 = String.valueOf(this.gsUrlPrefix);
        String string3 = String.valueOf(filename);
        stringArray[1] = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        stringArray[2] = target.toString();
        this.gsutil(stringArray);
    }

    @Override
    public void deleteFile(String filename) throws IOException {
        String string = String.valueOf(filename);
        logger.finer(string.length() != 0 ? "Deleting filename: ".concat(string) : new String("Deleting filename: "));
        String[] stringArray = new String[2];
        stringArray[0] = "rm";
        String string2 = String.valueOf(this.gsUrlPrefix);
        String string3 = String.valueOf(filename);
        stringArray[1] = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        this.gsutil(stringArray);
    }

    @Override
    public List<String> listFiles() throws IOException {
        List<String> gsutilOut = this.gsutil("ls", this.gsUrlPrefix);
        int urlPrefixLength = this.gsUrlPrefix.length();
        ArrayList<String> files = new ArrayList<String>(gsutilOut.size());
        for (String file : gsutilOut) {
            if (Objects.equals(file = file.substring(urlPrefixLength), LAST_BACKUP_FILE) || Objects.equals(file, EXISTING_FILE_METADATA) || Objects.equals(file, "jenkins-upgrade-version")) continue;
            files.add(file);
        }
        return files;
    }

    @Override
    public List<String> findLatestBackup() {
        List<String> files;
        try {
            files = this.getObjectFromGCS(LAST_BACKUP_FILE);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Exception while loading last-backup file", e);
            return null;
        }
        if (files.isEmpty()) {
            logger.info("Last-backup file is empty, no backups available.");
            return null;
        }
        return files;
    }

    @Override
    public List<String> listMetadataForExistingFiles() throws IOException {
        List<String> files;
        try {
            files = this.getObjectFromGCS(EXISTING_FILE_METADATA);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Exception while loading existing file metatdata. Files previously deleted may load", e);
            return new ArrayList<String>();
        }
        if (files.isEmpty()) {
            logger.warning("No files listed in existing files meta data. Either this is brand new or there was an issue in backup.");
            return files;
        }
        return files;
    }

    @Override
    public String getVersionInfo() {
        List<String> files;
        try {
            files = this.getObjectFromGCS("jenkins-upgrade-version");
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Exception while loading version info", e);
            return null;
        }
        if (files.isEmpty()) {
            logger.warning("No files listed in version number. Either this is brand new or there was an issue in backup.");
            return null;
        }
        return files.get(0);
    }

    private List<String> getObjectFromGCS(String name) throws IOException {
        List<String> content = null;
        LinkedList<String> files = new LinkedList<String>();
        String[] stringArray = new String[2];
        stringArray[0] = "cat";
        String string = String.valueOf(this.gsUrlPrefix);
        String string2 = String.valueOf(name);
        stringArray[1] = string2.length() != 0 ? string.concat(string2) : new String(string);
        content = this.gsutil(stringArray);
        if (content.isEmpty()) {
            return files;
        }
        for (String line : content) {
            if (line.trim().isEmpty() || line.startsWith(COMMENT_PREFIX)) continue;
            files.add(line.trim());
        }
        return files;
    }

    @Override
    public void updateLastBackup(List<String> filenames) throws IOException {
        logger.fine("Updating last-backup file.");
        this.uploadObjectToGCSS(filenames, LAST_BACKUP_FILE, COMMENT_LINE);
    }

    @Override
    public void updateExistingFilesMetaData(Set<String> filenames) throws IOException {
        logger.fine("Updating existing files meta data.");
        this.uploadObjectToGCSS(Lists.newArrayList(filenames), EXISTING_FILE_METADATA, EXISTING_FILES_COMMENT_LINE);
    }

    @Override
    public void updateVersionInfo(String version) throws IOException {
        if (version == null) {
            return;
        }
        String string = String.valueOf(version);
        logger.fine(string.length() != 0 ? "Updating version information: version ".concat(string) : new String("Updating version information: version "));
        this.uploadObjectToGCSS(Arrays.asList(version), "jenkins-upgrade-version", "#This file contains the upgrade version for the jenkins instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadObjectToGCSS(List<String> filenames, String name, String comment) throws IOException {
        ArrayList<String> content = new ArrayList<String>(filenames.size() + 1);
        content.add(comment);
        content.addAll(filenames);
        Path tempDirectory = Files.createTempDirectory(TMP_DIR_PREFIX, new FileAttribute[0]);
        Path tempFilePath = tempDirectory.resolve(name);
        String string = String.valueOf(tempFilePath);
        logger.fine(new StringBuilder(17 + String.valueOf(string).length()).append("Using temp file: ").append(string).toString());
        try {
            Files.write(tempFilePath, content, StandardCharsets.UTF_8, new OpenOption[0]);
            String[] stringArray = new String[3];
            stringArray[0] = "cp";
            stringArray[1] = tempFilePath.toString();
            String string2 = String.valueOf(this.gsUrlPrefix);
            String string3 = String.valueOf(name);
            stringArray[2] = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            this.gsutil(stringArray);
        }
        finally {
            logger.fine("Cleaning up temp file & directory.");
            Files.deleteIfExists(tempFilePath);
            Files.deleteIfExists(tempDirectory);
        }
    }

    private List<String> gsutil(String ... params) throws IOException {
        int returnCode;
        ProcessBuilder builder = new ProcessBuilder(GSUTIL_CMD);
        for (String string : params) {
            builder.command().add(string);
        }
        builder.redirectErrorStream(true);
        LinkedList<String> output = new LinkedList<String>();
        Process process = builder.start();
        Throwable throwable = null;
        try (BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = out.readLine()) != null) {
                output.add(line);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        try {
            returnCode = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Could not wait for sub-process", interruptedException);
        }
        if (returnCode != 0) {
            String string = String.valueOf(GcloudGcsStorage.joinStrings(output));
            throw new IOException(string.length() != 0 ? "gsutil failed: ".concat(string) : new String("gsutil failed: "));
        }
        return output;
    }

    private static String joinStrings(List<String> output) {
        StringBuilder sb = new StringBuilder();
        for (String line : output) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcloudGcsStorage that = (GcloudGcsStorage)o;
        return this.gsUrlPrefix.equals(that.gsUrlPrefix);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.gsUrlPrefix});
    }

    public String toString() {
        String string = String.valueOf("GcloudGcsStorage{gsUrlPrefix='");
        String string2 = this.gsUrlPrefix;
        return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("'").append("}").toString();
    }
}

