/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.scope;

import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class Scopes {
    private static final Logger logger = Logger.getLogger(Scopes.class.getName());

    private Scopes() {
    }

    public static void addAllFilesIn(final Path basePath, final Volume.Creator creator, final Set<Path> excludedDirs, final Set<String> existingFileMetadata) throws IOException {
        Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (attrs.isSymbolicLink()) {
                    String string = String.valueOf(dir);
                    logger.finer(new StringBuilder(28 + String.valueOf(string).length()).append("Skipping symlink directory: ").append(string).toString());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (excludedDirs.contains(dir)) {
                    String string = String.valueOf(dir);
                    logger.finer(new StringBuilder(29 + String.valueOf(string).length()).append("Skipping excluded directory: ").append(string).toString());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
                    if (!directoryStream.iterator().hasNext()) {
                        String string = String.valueOf(dir);
                        logger.finer(new StringBuilder(24 + String.valueOf(string).length()).append("Adding empty directory: ").append(string).toString());
                        existingFileMetadata.add(basePath.relativize(dir).toString());
                        creator.addFile(dir, basePath.relativize(dir).toString(), attrs);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (excludedDirs.contains(file)) {
                    String string = String.valueOf(file);
                    logger.finer(new StringBuilder(24 + String.valueOf(string).length()).append("Skipping excluded file: ").append(string).toString());
                } else {
                    String string = String.valueOf(file);
                    logger.finer(new StringBuilder(13 + String.valueOf(string).length()).append("Adding file: ").append(string).toString());
                    existingFileMetadata.add(basePath.relativize(file).toString());
                    creator.addFile(file, basePath.relativize(file).toString(), attrs);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (excludedDirs.contains(file)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.visitFileFailed(file, exc);
            }
        });
    }

    public static void extractAllFilesTo(Path targetDir, Volume.Extractor extractor, boolean overwrite, Map<String, Boolean> existingFileMetadataMap) throws IOException {
        boolean isExistingFileMetadata = !existingFileMetadataMap.isEmpty();
        for (Volume.Entry entry : extractor) {
            Boolean shouldRestoreFromBackup;
            if (isExistingFileMetadata && !existingFileMetadataMap.containsKey(entry.getName())) {
                String string = String.valueOf("File found in storage volume with no corresponding entry in list of existing files: ");
                String string2 = String.valueOf(entry.getName());
                logger.fine(string2.length() != 0 ? string.concat(string2) : new String(string));
                continue;
            }
            Path path = targetDir.resolve(entry.getName());
            if (overwrite || !Files.exists(path, new LinkOption[0])) {
                existingFileMetadataMap.put(entry.getName(), true);
            }
            if ((shouldRestoreFromBackup = existingFileMetadataMap.get(entry.getName())) == null || !shouldRestoreFromBackup.booleanValue()) continue;
            entry.extractTo(path);
        }
    }
}

