/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster.scope;

import com.google.common.annotations.VisibleForTesting;
import com.google.jenkins.plugins.persistentmaster.scope.ConfigurableScope;
import com.google.jenkins.plugins.persistentmaster.scope.Messages;
import com.google.jenkins.plugins.persistentmaster.scope.Scopes;
import com.google.jenkins.plugins.persistentmaster.volume.Volume;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class CustomScope
extends ConfigurableScope {
    @VisibleForTesting
    public static final String DISPLAY_NAME = Messages.CustomScope_DisplayName();
    @VisibleForTesting
    public static final String EXCLUDE_DISPLAY_NAME = Messages.CustomScope_ExcludeDisplayName();
    private final String filepath;
    private final String scopeName;
    private final List<Exclude> excludedFilepaths;

    @DataBoundConstructor
    public CustomScope(String filepath, String scopeName, List<Exclude> excludedFilepaths) {
        this.filepath = filepath;
        this.scopeName = scopeName;
        this.excludedFilepaths = excludedFilepaths == null ? new ArrayList() : excludedFilepaths;
    }

    public String getFilepath() {
        return this.filepath;
    }

    @Override
    public String getScopeName() {
        return this.scopeName;
    }

    public List<Exclude> getExcludedFilepaths() {
        return this.excludedFilepaths;
    }

    @Override
    public void addFiles(Path jenkinsHome, Volume.Creator creator, Set<String> existingFileMetadata) throws IOException {
        HashSet<Path> excludedDirs = new HashSet<Path>();
        Path basePath = jenkinsHome.resolve(this.filepath);
        if (this.excludedFilepaths != null) {
            for (Exclude exclude : this.excludedFilepaths) {
                excludedDirs.add(basePath.resolve(exclude.getExcludedFilepath()));
            }
        }
        Scopes.addAllFilesIn(basePath, creator, excludedDirs, existingFileMetadata);
    }

    @Override
    public void extractFiles(Path jenkinsHome, Volume.Extractor extractor, boolean overwrite, Map<String, Boolean> existingFileMetadataMap) throws IOException {
        Scopes.extractAllFilesTo(jenkinsHome.resolve(this.filepath), extractor, overwrite, existingFileMetadataMap);
    }

    public static class Exclude
    implements Describable<Exclude> {
        private String excludedFilepath;

        @DataBoundConstructor
        public Exclude(String excludedFilepath) {
            this.excludedFilepath = excludedFilepath;
        }

        public void setExcludedFilepath(String excludedFilepath) {
            this.excludedFilepath = excludedFilepath;
        }

        public String getExcludedFilepath() {
            return this.excludedFilepath;
        }

        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptor(this.getClass());
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<Exclude> {
            public String getDisplayName() {
                return EXCLUDE_DISPLAY_NAME;
            }
        }
    }

    @Extension
    public static class CustomScopeDescriptor
    extends ConfigurableScope.ConfigurableScopeDescriptor {
        public String getDisplayName() {
            return DISPLAY_NAME;
        }
    }
}

