/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public final class VersionUtility {
    public static final String VERSION_FILE = "jenkins-upgrade-version";
    public static final String COMMENT_PREFIX = "#";
    public static final String COMMENT_LINE = "#This file contains the upgrade version for the jenkins instance";
    private static final Logger logger = Logger.getLogger(VersionUtility.class.getName());

    public static String getFileSystemVersion(Path jenkinsHome) {
        Path versionPath = jenkinsHome.resolve(VERSION_FILE);
        String version = null;
        try {
            if (versionPath != null && Files.exists(versionPath, new LinkOption[0])) {
                List<String> lines = Files.readAllLines(versionPath, StandardCharsets.UTF_8);
                for (String line : lines) {
                    if (line == null || line.trim().isEmpty() || line.startsWith(COMMENT_PREFIX)) continue;
                    version = line;
                }
            }
            return version;
        }
        catch (IOException e) {
            String string = String.valueOf(e);
            logger.fine(new StringBuilder(44 + String.valueOf(string).length()).append("Exception trying to read filesystem version ").append(string).toString());
            return null;
        }
    }

    public static void updateFileSystemVersion(Path storageDir, String version) throws IOException {
        Path path = storageDir.resolve(VERSION_FILE);
        LinkedList<String> content = new LinkedList<String>(Arrays.asList(version));
        content.addFirst(COMMENT_LINE);
        Files.write(path, content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

