/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster;

import com.google.jenkins.plugins.persistentmaster.PersistentMasterPlugin;
import com.google.jenkins.plugins.persistentmaster.backup.BackupProcedure;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.joda.time.DateTime;

@Extension
public class PersistentMasterAsyncPeriodicWork
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(PersistentMasterAsyncPeriodicWork.class.getName());
    private static final String WORKER_NAME = "PersistentMaster-Worker";

    public static String getLogFileName() {
        return "PersistentMaster-Worker.log";
    }

    static PersistentMasterAsyncPeriodicWork getInstance() {
        return (PersistentMasterAsyncPeriodicWork)((Object)Jenkins.getActiveInstance().getExtensionList(AsyncPeriodicWork.class).get(PersistentMasterAsyncPeriodicWork.class));
    }

    public PersistentMasterAsyncPeriodicWork() {
        super(WORKER_NAME);
    }

    protected void execute(TaskListener taskListener) throws IOException, InterruptedException {
        PersistentMasterPlugin plugin = PersistentMasterPlugin.getInstance();
        if (plugin == null) {
            throw new IllegalStateException("Plugin instance is not available");
        }
        if (plugin.isLoaded() && plugin.getEnableBackup()) {
            if (this.shouldCreateFullBackup(plugin)) {
                this.createBackup(plugin, true);
            } else if (this.shouldCreateIncrementalBackup(plugin)) {
                this.createBackup(plugin, false);
            }
        }
    }

    boolean shouldCreateFullBackup(PersistentMasterPlugin plugin) {
        if (plugin.getLastFullBackupTime() == null || plugin.isManualBackupRequested()) {
            return true;
        }
        return plugin.getFullBackupTrigger().shouldCreateBackup(plugin.getLastFullBackupTime());
    }

    private boolean shouldCreateIncrementalBackup(PersistentMasterPlugin plugin) {
        return plugin.getIncrementalBackupTrigger().shouldCreateBackup(plugin.getLastBackupTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createBackup(PersistentMasterPlugin plugin, boolean fullBackup) {
        if (!plugin.beginBackupOrRestore()) {
            return;
        }
        try {
            try {
                BackupProcedure backupProcedure = fullBackup ? plugin.getFullBackupProcedure() : plugin.getIncrementalBackupProcedure();
                DateTime backupTime = backupProcedure.performBackup();
                plugin.setLastBackupTime(backupTime);
                if (fullBackup) {
                    plugin.setLastFullBackupTime(backupTime);
                }
                plugin.setLastBackupFailed(false);
            }
            catch (IOException e) {
                plugin.setLastBackupFailed(true);
                LOGGER.log(Level.SEVERE, "IOException while creating backup", e);
            }
        }
        finally {
            if (fullBackup && !plugin.isLastBackupFailed()) {
                plugin.setManualBackupRequested(false);
            }
            plugin.endBackupOrRestore();
        }
    }

    public long getRecurrencePeriod() {
        return 60000L;
    }
}

