/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.persistentmaster;

import com.google.jenkins.plugins.persistentmaster.Messages;
import com.google.jenkins.plugins.persistentmaster.PersistentMasterPlugin;
import hudson.Extension;
import hudson.model.ManagementLink;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class BackupManager
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(BackupManager.class.getName());

    public String getDescription() {
        return Messages.BackupManager_Description();
    }

    public String getIconFileName() {
        return "folder.png";
    }

    public String getUrlName() {
        return "backupConsole";
    }

    public String getConfigFileName() {
        return "backupConfig.xml";
    }

    public String getDisplayName() {
        return Messages.BackupManager_DisplayName();
    }

    public void doBackupNow(StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
        LOGGER.info("Full backup manually triggered.");
        PersistentMasterPlugin plugin = PersistentMasterPlugin.getInstance();
        if (plugin == null || !plugin.isLoaded()) {
            LOGGER.warning("Persistent Master Plugin instance missing when attempting manually triggered backup.");
            return;
        }
        if (!plugin.getEnableBackup()) {
            LOGGER.warning("Backup was manually triggered but backups are disabled.");
            return;
        }
        plugin.setManualBackupRequested(true);
        res.forwardToPreviousPage(req);
    }
}

